import { a as useHead } from "../server.mjs";
import { defineComponent, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs } from "vue/server-renderer";
import "ohmyfetch";
import "#internal/nitro";
import "hookable";
import "unctx";
import "destr";
import "ufo";
import "h3";
import "@vueuse/shared";
import "vue-router";
import "defu";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "abstract-metabox",
  __ssrInlineRender: true,
  setup(__props) {
    useHead({
      title: "AbstractMetaBox"
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "container mx-auto" }, _attrs))}><h1>AbstractMetaBox</h1><ul><li>Description: Meta box Abstract class</li><li>Class name: AbstractMetaBox</li><li>Namespace: \\RayTech\\WPAbstractClasses\\MetaBoxes</li><li>This is an <strong>abstract</strong> class</li></ul><hr><h2>Properties</h2><div class="grid grid-cols-1 md:grid-cols-2 gap-4"><div class="mb-6"><h3 class="text-center">config</h3><p>private config</p><p>Configuration array of the input fiels in the meta box</p><ul><li>Visibility: <strong>private</strong></li><li>Variable type: Array</li></ul></div><div class="mb-6"><h3 class="text-center">columns</h3><p>private columns</p><p>Amount of columns to seperate the meta box in.</p><ul><li>Visibility: <strong>private</strong></li><li>Variable type: Integer</li></ul></div><div class="mb-6"><h3 class="text-center">header</h3><p>private header = &#39;&#39;</p><p>This will set the label of the header of the meta box.</p><ul><li>Visibility: <strong>private</strong></li><li>Variable type: String</li></ul></div><div class="mb-6"><h3 class="text-center">slug</h3><p>private slug = &#39;meta&#39;</p><p>The slug of the meta box.</p><ul><li>Visibility: <strong>private</strong></li><li>Variable type: String</li></ul></div><div class="mb-6"><h3 class="text-center">post_type_class</h3><p>private post_type_class</p><p>Post type name class string.</p><ul><li>Visibility: <strong>private</strong></li><li>Variable type: String</li></ul></div><div class="mb-6"><h3 class="text-center">post_type_name</h3><p>private post_type_name</p><p>Post type name string.</p><ul><li>Visibility: <strong>private</strong></li><li>Variable type: String</li></ul></div><div class="mb-6"><h3 class="text-center">post_type</h3><p>private post_type</p><p>Post type slug to use to create the post type</p><ul><li>Visibility: <strong>private</strong></li><li>Variable type: String</li></ul></div></div><hr><h2>Methods</h2><div><h3>__construct</h3><p>mixed AbstractMetaBox::__construct()</p><p>Constructor method which sets some variable and adds action for the meta boxes.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>add_boxes_setup</h3><p>void AbstractMetaBox::add_boxes_setup()</p><p>Add actions for adding the meta box and saving the meta data.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>getConfig</h3><p>array AbstractMetaBox::getConfig()</p><p>This method is required and sets the needed inputs and their attributes for the meta box.</p><ul><li>Visibility: <strong>protected</strong></li></ul></div><div><h3>add_boxes</h3><p>void AbstractMetaBox::add_boxes()</p><p>Add meta boxes to the admin edit page of the post type.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>addInput</h3><p>void AbstractMetaBox::addInput(string type, string label, string id, array attr)</p><p>Adds an input to the meta box configuration.</p><ul><li>Visibility: <strong>protected</strong></li></ul><h4>Arguments</h4><ul><li>type <strong>string</strong> -HTML input type.</li><li>label <strong>string</strong> -Sets the label of the input.</li><li>id <strong>string</strong> -Sets the HTML attributes id and name with this variable linking it to the label.</li><li>attr <strong>array</strong> -An array of all the other possible HTML attributes.</li></ul></div><div><h3>meta_boxes</h3><p>void AbstractMetaBox::meta_boxes(\\WP_Post post)</p><p>Meta boxes rendering function</p><ul><li>* Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>post <strong>\\WP_Post</strong> -post data object.</li></ul></div><div><h3>save_meta</h3><p>int AbstractMetaBox::save_meta(int post_id, \\WP_Post post)</p><p>Save the meta box&#39;s post metadata.</p><ul><li>* Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>post_id <strong>int</strong> -Post Id.</li><li>post <strong>\\WP_Post</strong> -Post Object.</li></ul></div><div><h3>getSlug</h3><p>string AbstractMetaBox::getSlug()</p><p>Get the slug of the meta box.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setSlug</h3><p>self AbstractMetaBox::setSlug(string slug)</p><p>Set the slug of the meta box.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>slug <strong>string</strong> -The slug of the meta box.</li></ul></div><div><h3>getColumns</h3><p>int AbstractMetaBox::getColumns()</p><p>Get amount of columns to seperate the meta box in.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setColumns</h3><p>self AbstractMetaBox::setColumns(int columns)</p><p>Set amount of columns to seperate the meta box in.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>columns <strong>int</strong> -Amount of columns to seperate the meta box in.</li></ul></div><div><h3>getHeader</h3><p>string AbstractMetaBox::getHeader()</p><p>Get this will set the label of the header of the meta box.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setHeader</h3><p>self AbstractMetaBox::setHeader(string header)</p><p>Set this will set the label of the header of the meta box.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>header <strong>string</strong> -This will set the label of the header of the meta box.</li></ul></div><div><h3>getPostType</h3><p>string AbstractMetaBox::getPostType()</p><p>Get post type slug to use to create the post type</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setPostType</h3><p>self AbstractMetaBox::setPostType(string post_type)</p><p>Set post type slug to use to create the post type. This method is required to create the post type and the only needed method to call to create</p><ul><li>* Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>post_type <strong>string</strong> -Post type slug to use to create the post type.</li></ul></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/api/metaboxes/abstract-metabox.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=abstract-metabox.ce3525e3.js.map
