import { a as useHead } from "../server.mjs";
import { defineComponent, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs } from "vue/server-renderer";
import "ohmyfetch";
import "#internal/nitro";
import "hookable";
import "unctx";
import "destr";
import "ufo";
import "h3";
import "@vueuse/shared";
import "vue-router";
import "defu";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "getting-started",
  __ssrInlineRender: true,
  setup(__props) {
    useHead({
      title: "Getting Started"
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "container mx-auto" }, _attrs))}><h1 class="mb-8">Getting Started</h1><p> I will try to explain to the best that I can about coding in a object-oriented way within the WordPress platform. To start off I would like to state that Composer can and should be used in themes and plugins for Autoloading purposes at the very least, but should also be used to add dependencies when needed like our WPAbstractClasses Package to help make the developement of functionality a breeze, and that way we can concentrate on the important non-redundant part of the application. And here is the best way to install composer in a theme.</p><ul class="list-decimal list-inside mt-8"><li>Initiate the composer in your themes root folder.<br><br><pre class="language-bash"><code>composer init</code></pre></li><li>Install the depedency.<br><br><pre class="language-bash"><code>composer require raytechhosting/wpabstractclasses</code></pre></li><li>Once the install is completed we need to add the autoload as the first line of code WordPress will read which is the functions.php file in the root folder of your theme, or the entrypoint file of your plugin (usually the file with the name of the plugin at the root of the plugin).<br><br><pre class="language-php"><code>require get_stylesheet_directory() . &#39;vendor/autoload.php&#39;;</code></pre></li><li>From there on you can use all the classes in the package but your own classes wont be autoloaded until you tell composer where to look and under what namespace to load them as. So we will set this up within the composer.json which is located again in your root folder of your theme. and btw the \\ in the namespace key needs to be escaped for it to work properly so doubled.<br><br><pre class="language-json"><code>{
	&quot;autoload&quot;: {
		&quot;psr-4&quot;: {
			&quot;RayTech\\\\&quot;: &quot;src/&quot;
		}
	},
}</code>
			</pre></li><li>And now only thing left to do is to make composer recheck for new classes and this can be acheived using this command<br><pre class="language-bash"><code>composer dump-autoload -o</code></pre></li></ul><p>So now the autoloading is setup, you won\u2019t have to include all the files to have the classes available to use. You can just make the call to a class:</p><p>Via a use statement</p><pre class="language-php"><code>use RayTech\\WPAbstractClasses\\PostTypes\\AbstractPostType;

class PostType extends AbstractPostType {}</code></pre><p>or directly</p><pre class="language-php"><code>class PostType extends RayTech\\WPAbstractClasses\\PostTypes\\AbstractPostType {}</code></pre><p>We are now at the best part, which is using it to modify WordPress using action and filter hooks in your classes.</p><p>Here is how you can acheive that using a constructor. The callback argument needs to be an array when used in a class and \u2018$this\u2019 will always be the first data in the array so WordPress knows which class to use.</p><pre class="language-php"><code>class Assets {
	public function __construct() {
		add_action(&#39;wp_enqueue_scripts&#39;, [ $this, &#39;enqueue_front_styles&#39; ], 99999);
	}

	public function enqueue_front_styles() {
		wp_enqueue_style(&#39;{file handler}&#39;, &#39;{CSS file location}&#39;);
	}
}</code></pre></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/getting-started.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=getting-started.4eb616ec.js.map
