import { a as useHead } from "../server.mjs";
import { defineComponent, useSSRContext } from "vue";
import { ssrRenderAttrs } from "vue/server-renderer";
import "ohmyfetch";
import "#internal/nitro";
import "hookable";
import "unctx";
import "destr";
import "ufo";
import "h3";
import "@vueuse/shared";
import "vue-router";
import "defu";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "labels",
  __ssrInlineRender: true,
  setup(__props) {
    useHead({
      title: "Labels"
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(_attrs)}><h1>Labels</h1><ul><li>Description: This class will help create default labels and customize labels for the taxonomy class. </li><li>Class name: Labels</li><li>Namespace: \\RayTech\\WPAbstractClasses\\Taxonomies</li></ul><hr><h2>Properties</h2><div class="grid grid-cols-1 md:grid-cols-2"><div><h3>name</h3><p>private name</p><p>General name for the taxonomy, usually plural. The same as and overridden by $tax-&gt;label. Default &#39;Tags&#39;/&#39;Categories&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>singular_name</h3><p>private singular_name</p><p>Name for one object of this taxonomy. Default &#39;Tag&#39;/&#39;Category&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>search_items</h3><p>private search_items</p><p>Default &#39;Search Tags&#39;/&#39;Search Categories&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>popular_items</h3><p>private popular_items</p><p>This label is only used for non-hierarchical taxonomies. Default &#39;Popular Tags&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>all_items</h3><p>private all_items</p><p>Default &#39;All Tags&#39;/&#39;All Categories&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>parent_item</h3><p>private parent_item</p><p>This label is only used for hierarchical taxonomies. Default &#39;Parent Category&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>parent_item_colon</h3><p>private parent_item_colon</p><p>The same as parent_item, but with colon : in the end.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>name_field_description</h3><p>private name_field_description</p><p>Description for the Name field on Edit Tags screen. Default &#39;The name is how it appears on your site&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>slug_field_description</h3><p>private slug_field_description</p><p>Description for the Slug field on Edit Tags screen. Default &#39;The \u201Cslug\u201D is the URL-friendly version of the name. It is usually all lowercase and contains only letters, numbers, and hyphens&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>parent_field_description</h3><p>private parent_field_description</p><p>Description for the Parent field on Edit Tags screen. Default &#39;Assign a parent term to create a hierarchy. The term Jazz, for example, would be the parent of Bebop and Big Band&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>desc_field_description</h3><p>private desc_field_description</p><p>Description for the Description field on Edit Tags screen. Default &#39;The description is not prominent by default; however, some themes may show it&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>edit_item</h3><p>private edit_item</p><p>Default &#39;Edit Tag&#39;/&#39;Edit Category&#39;. </p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>view_item</h3><p>private view_item</p><p>Default &#39;View Tag&#39;/&#39;View Category&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>update_item</h3><p>private update_item</p><p>Default &#39;Update Tag&#39;/&#39;Update Category&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>add_new_item</h3><p>private add_new_item</p><p>Default &#39;Add New Tag&#39;/&#39;Add New Category&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>new_item_name</h3><p>private new_item_name</p><p>Default &#39;New Tag Name&#39;/&#39;New Category Name&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>separate_items_with_commas</h3><p>private separate_items_with_commas</p><p>This label is only used for non-hierarchical taxonomies. Default &#39;Separate tags with commas&#39;, used in the meta box.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>add_or_remove_items</h3><p>private add_or_remove_items</p><p>This label is only used for non-hierarchical taxonomies. Default &#39;Add or remove tags&#39;, used in the meta box when JavaScript is disabled.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>choose_from_most_used</h3><p>private choose_from_most_used</p><p>This label is only used on non-hierarchical taxonomies. Default &#39;Choose from the most used tags&#39;, used in the meta box.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>not_found</h3><p>private not_found</p><p>Default &#39;No tags found&#39;/&#39;No categories found&#39;, used in the meta box and taxonomy list table.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>no_terms</h3><p>private no_terms</p><p>Default &#39;No tags&#39;/&#39;No categories&#39;, used in the posts and media list tables.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>filter_by_item</h3><p>private filter_by_item</p><p>This label is only used for hierarchical taxonomies. Default &#39;Filter by category&#39;, used in the posts list table.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>items_list_navigation</h3><p>private items_list_navigation</p><p>Label for the table pagination hidden heading.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>items_list</h3><p>private items_list</p><p>Label for the table hidden heading.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>most_used</h3><p>private most_used</p><p>Title for the Most Used tab. Default &#39;Most Used&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>back_to_items</h3><p>private back_to_items</p><p>Label displayed after a term has been updated.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>item_link</h3><p>private item_link</p><p>Used in the block editor. Title for a navigation link block variation. Default &#39;Tag Link&#39;/&#39;Category Link&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>item_link_description</h3><p>private item_link_description</p><p>Used in the block editor. Description for a navigation link block variation. Default &#39;A link to a tag&#39;/&#39;A link to a category&#39;.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>type</h3><p>private type</p><p>This decides whether you wish to have a tag taxonomy or a category taxonomy.</p><ul><li>Visibility: <strong>private</strong></li></ul></div><div><h3>post_type</h3><p>private post_type</p><p>Post type slug to use to create the post type</p><ul><li>Visibility: <strong>private</strong></li></ul></div></div><hr><h2>Methods</h2><div><h3>__construct</h3><p>mixed __construct(string post_type, string type)</p><p>Constructor method that creates the taxonomy and sets some defaults.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>post_type <strong>string</strong> -Post type slug.</li><li>type <strong>string</strong> -Taxonomy Type.</li></ul></div><div><h3>toArray</h3><p>array toArray()</p><p>Converts the class properties to an array to pass to the register_taxonomy function.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>getName</h3><p>string getName()</p><p>Get general name for the taxonomy, usually plural. The same as and overridden by $tax-&gt;label. Default &#39;Tags&#39;/&#39;Categories&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setName</h3><p>self setName(string name)</p><p>Set general name for the taxonomy, usually plural. The same as and overridden by $tax-&gt;label. Default &#39;Tags&#39;/&#39;Categories&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>name <strong>string</strong> -General name for the taxonomy, usually plural. The same as and overridden by $tax-&gt;label. Default &#39;Tags&#39;/&#39;Categories&#39;.</li></ul></div><div><h3>getSingularName</h3><p>string getSingularName()</p><p>Get name for one object of this taxonomy. Default &#39;Tag&#39;/&#39;Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setSingularName</h3><p>self setSingularName(string singular_name)</p><p>Set name for one object of this taxonomy. Default &#39;Tag&#39;/&#39;Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>singular_name <strong>string</strong> -Name for one object of this taxonomy. Default &#39;Tag&#39;/&#39;Category&#39;.</li></ul></div><div><h3>getSearchItems</h3><p>string getSearchItems()</p><p>Get default &#39;Search Tags&#39;/&#39;Search Categories&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setSearchItems</h3><p>self setSearchItems(string search_items)</p><p>Set default &#39;Search Tags&#39;/&#39;Search Categories&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>search_items <strong>string</strong> -Default &#39;Search Tags&#39;/&#39;Search Categories&#39;. </li></ul></div><div><h3>getPopularItems</h3><p>string getPopularItems()</p><p>Get default &#39;Popular Tags&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setPopularItems</h3><p>self setPopularItems(string popular_items)</p><p>Set default &#39;Popular Tags&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>popular_items <strong>string</strong> -Default &#39;Popular Tags&#39;.</li></ul></div><div><h3>getAllItems</h3><p>string getAllItems()</p><p>Get default &#39;All Tags&#39;/&#39;All Categories&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setAllItems</h3><p>self setAllItems(string all_items)</p><p>Set default &#39;All Tags&#39;/&#39;All Categories&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>all_items <strong>string</strong> -Default &#39;All Tags&#39;/&#39;All Categories&#39;.</li></ul></div><div><h3>getParentItem</h3><p>string getParentItem()</p><p>Get this label is only used for hierarchical taxonomies. Default &#39;Parent Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setParentItem</h3><p>self setParentItem(string parent_item)</p><p>Set this label is only used for hierarchical taxonomies. Default &#39;Parent Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>parent_item <strong>string</strong> -This label is only used for hierarchical taxonomies. Default &#39;Parent Category&#39;.</li></ul></div><div><h3>getParentItemColon</h3><p>string getParentItemColon()</p><p>Get the same as parent_item, but with colon : in the end.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setParentItemColon</h3><p>self setParentItemColon(string parent_item_colon)</p><p>Set the same as parent_item, but with colon : in the end.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>parent_item_colon <strong>string</strong> -The same as parent_item, but with colon : in the end. </li></ul></div><div><h3>getNameFieldDescription</h3><p>string getNameFieldDescription()</p><p>Get default &#39;The name is how it appears on your site&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setNameFieldDescription</h3><p>self setNameFieldDescription(string name_field_description)</p><p>Set default &#39;The name is how it appears on your site&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>name_field_description <strong>string</strong> -Default &#39;The name is how it appears on your site&#39;.</li></ul></div><div><h3>getSlugFieldDescription</h3><p>string getSlugFieldDescription()</p><p>Get and hyphens&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setSlugFieldDescription</h3><p>self setSlugFieldDescription(string slug_field_description) </p><p>Set and hyphens&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>slug_field_description <strong>string</strong> -and hyphens&#39;.</li></ul></div><div><h3>getParentFieldDescription</h3><p>string getParentFieldDescription()</p><p>Get the term Jazz, for example, would be the parent of Bebop and Big Band&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setParentFieldDescription</h3><p>self setParentFieldDescription(string parent_field_description)</p><p>Set the term Jazz, for example, would be the parent of Bebop and Big Band&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>parent_field_description <strong>string</strong> -The term Jazz, for example, would be the parent of Bebop and Big Band&#39;.</li></ul></div><div><h3>getDescFieldDescription</h3><p>string getDescFieldDescription()</p><p>Get default &#39;The description is not prominent by default; however, some themes may show it&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setDescFieldDescription</h3><p>self setDescFieldDescription(string desc_field_description) </p><p>Set default &#39;The description is not prominent by default; however, some themes may show it&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>desc_field_description <strong>string</strong> -Default &#39;The description is not prominent by default; however, some themes may show it&#39;.</li></ul></div><div><h3>getEditItem</h3><p>string getEditItem()</p><p>Get default &#39;Edit Tag&#39;/&#39;Edit Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setEditItem</h3><p>self setEditItem(string edit_item)</p><p>Set default &#39;Edit Tag&#39;/&#39;Edit Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>edit_item <strong>string</strong> -Default &#39;Edit Tag&#39;/&#39;Edit Category&#39;.</li></ul></div><div><h3>getViewItem</h3><p>string getViewItem()</p><p>Get default &#39;View Tag&#39;/&#39;View Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setViewItem</h3><p>self setViewItem(string view_item)</p><p>Set default &#39;View Tag&#39;/&#39;View Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>view_item <strong>string</strong> -Default &#39;View Tag&#39;/&#39;View Category&#39;.</li></ul></div><div><h3>getUpdateItem</h3><p>string getUpdateItem()</p><p>Get default &#39;Update Tag&#39;/&#39;Update Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setUpdateItem</h3><p>self setUpdateItem(string update_item)</p><p>Set default &#39;Update Tag&#39;/&#39;Update Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>update_item <strong>string</strong> -Default &#39;Update Tag&#39;/&#39;Update Category&#39;. </li></ul></div><div><h3>getAddNewItem</h3><p>string getAddNewItem()</p><p>Get default &#39;Add New Tag&#39;/&#39;Add New Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setAddNewItem</h3><p>self setAddNewItem(string add_new_item)</p><p>Set default &#39;Add New Tag&#39;/&#39;Add New Category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>add_new_item <strong>string</strong> -Default &#39;Add New Tag&#39;/&#39;Add New Category&#39;. </li></ul></div><div><h3>getNewItemName</h3><p>string getNewItemName()</p><p>Get default &#39;New Tag Name&#39;/&#39;New Category Name&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setNewItemName</h3><p>self setNewItemName(string new_item_name)</p><p>Set default &#39;New Tag Name&#39;/&#39;New Category Name&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>new_item_name <strong>string</strong> -Default &#39;New Tag Name&#39;/&#39;New Category Name&#39;.</li></ul></div><div><h3>getSeparateItemsWithCommas</h3><p>string getSeparateItemsWithCommas()</p><p>Get this label is only used for non-hierarchical taxonomies. Default &#39;Separate tags with commas&#39;, used in the meta box.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setSeparateItemsWithCommas</h3><p>self setSeparateItemsWithCommas(string separate_items_with_commas)</p><p>Set this label is only used for non-hierarchical taxonomies. Default &#39;Separate tags with commas&#39;, used in the meta box.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>separate_items_with_commas <strong>string</strong> -This label is only used for non-hierarchical taxonomies. Default &#39;Separate tags with commas&#39;, used in the meta box.</li></ul></div><div><h3>getAddOrRemoveItems</h3><p>string getAddOrRemoveItems()</p><p>Get javaScript is disabled.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setAddOrRemoveItems</h3><p>self setAddOrRemoveItems(string add_or_remove_items)</p><p>Set javaScript is disabled.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>add_or_remove_items <strong>string</strong> -JavaScript is disabled.</li></ul></div><div><h3>getChooseFromMostUsed</h3><p>string getChooseFromMostUsed()</p><p>Get this label is only used on non-hierarchical taxonomies. Default &#39;Choose from the most used tags&#39;, used in the meta box.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setChooseFromMostUsed</h3><p>self setChooseFromMostUsed(string choose_from_most_used)</p><p>Set this label is only used on non-hierarchical taxonomies. Default &#39;Choose from the most used tags&#39;, used in the meta box.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>choose_from_most_used <strong>string</strong> -This label is only used on non-hierarchical taxonomies. Default</li></ul> &#39;Choose from the most used tags&#39;, used in the meta box. </div><div><h3>getNotFound</h3><p>string getNotFound()</p><p>Get default &#39;No tags found&#39;/&#39;No categories found&#39;, used in the meta box and taxonomy list table.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setNotFound</h3><p>self setNotFound(string not_found)</p><p>Set default &#39;No tags found&#39;/&#39;No categories found&#39;, used in the meta box and taxonomy list table.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>not_found <strong>string</strong> -Default &#39;No tags found&#39;/&#39;No categories found&#39;, used in the meta</li></ul> box and taxonomy list table. </div><div><h3>getNoTerms</h3><p>string getNoTerms()</p><p>Get default &#39;No tags&#39;/&#39;No categories&#39;, used in the posts and media list tables.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setNoTerms</h3><p>self setNoTerms(string no_terms)</p><p>Set default &#39;No tags&#39;/&#39;No categories&#39;, used in the posts and media list tables.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>no_terms <strong>string</strong> -Default &#39;No tags&#39;/&#39;No categories&#39;, used in the posts and media list tables.</li></ul></div><div><h3>getFilterByItem</h3><p>string getFilterByItem()</p><p>Get this label is only used for hierarchical taxonomies. Default &#39;Filter by category&#39;, used in the posts list table.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setFilterByItem</h3><p>self setFilterByItem(string filter_by_item)</p><p>Set this label is only used for hierarchical taxonomies. Default &#39;Filter by category&#39;, used in the posts list table.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>filter_by_item <strong>string</strong> -This label is only used for hierarchical taxonomies. Default &#39;Filter by category&#39;, used in the posts list table.</li></ul></div><div><h3>getItemsListNavigation</h3><p>string getItemsListNavigation()</p><p>Get label for the table pagination hidden heading.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setItemsListNavigation</h3><p>self setItemsListNavigation(string items_list_navigation) </p><p>Set label for the table pagination hidden heading.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>items_list_navigation <strong>string</strong> -Label for the table pagination hidden heading.</li></ul></div><div><h3>getItemsList</h3><p>string getItemsList()</p><p>Get label for the table hidden heading.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setItemsList</h3><p>self setItemsList(string items_list)</p><p>Set label for the table hidden heading.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>items_list <strong>string</strong> -Label for the table hidden heading.</li></ul></div><div><h3>getMostUsed</h3><p>string getMostUsed()</p><p>Get title for the Most Used tab. Default &#39;Most Used&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setMostUsed</h3><p>self setMostUsed(string most_used)</p><p>Set title for the Most Used tab. Default &#39;Most Used&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>most_used <strong>string</strong> -Title for the Most Used tab. Default &#39;Most Used&#39;.</li></ul></div><div><h3>getBackToItems</h3><p>string getBackToItems()</p><p>Get label displayed after a term has been updated.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setBackToItems</h3><p>self setBackToItems(string back_to_items)</p><p>Set label displayed after a term has been updated.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>back_to_items <strong>string</strong> -Label displayed after a term has been updated.</li></ul></div><div><h3>getItemLink</h3><p>string getItemLink()</p><p>Get default &#39;Tag Link&#39;/&#39;Category Link&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setItemLink</h3><p>self setItemLink(string item_link)</p><p>Set default &#39;Tag Link&#39;/&#39;Category Link&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>item_link <strong>string</strong> -Default &#39;Tag Link&#39;/&#39;Category Link&#39;.</li></ul></div><div><h3>getItemLinkDescription</h3><p>string getItemLinkDescription()</p><p>Get to a category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setItemLinkDescription</h3><p>self setItemLinkDescription(string item_link_description) </p><p>Set to a category&#39;.</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>item_link_description <strong>string</strong> -to a category&#39;.</li></ul></div><div><h3>getType</h3><p>string getType()</p><p>Get the value of type</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setType</h3><p>self setType(string type)</p><p>Set the value of type</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>type <strong>string</strong> -Taxonomy type.</li></ul></div><div><h3>getPostType</h3><p>string getPostType()</p><p>Get post type slug to use to create the post type</p><ul><li>Visibility: <strong>public</strong></li></ul></div><div><h3>setPostType</h3><p>self setPostType(string post_type)</p><p>Set post type slug to use to create the post type. This method is required to create the post type and the only needed method to call to create</p><ul><li>Visibility: <strong>public</strong></li></ul><h4>Arguments</h4><ul><li>post_type <strong>string</strong> -Post type slug to use to create the post type.</li></ul></div></section>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/api/taxonomies/labels.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=labels.f688177e.js.map
