const $schema = "https://raw.githubusercontent.com/martinring/tmlanguage/master/tmlanguage.json";
const fileTypes = [
	"astro"
];
const foldingStartMarker = "(?x)\n(<(?i:head|body|table|thead|tbody|tfoot|tr|div|select|fieldset|style|script|ul|ol|li|form|dl)\\b.*?>\n|<!--(?!.*--\\s*>)\n|^<!--\\ \\#tminclude\\ (?>.*?-->)$\n|<\\?(?:php)?.*\\b(if|for(each)?|while)\\b.+:\n|\\{\\{?(if|foreach|capture|literal|foreach|php|section|strip)\n|\\{\\s*($|\\?>\\s*$|//|/\\*(.*\\*/\\s*$|(?!.*?\\*/)))\n)";
const foldingStopMarker = "(?x)\n(</(?i:head|body|table|thead|tbody|tfoot|tr|div|select|fieldset|style|script|ul|ol|li|form|dl)>\n|^(?!.*?<!--).*?--\\s*>\n|^<!--\\ end\\ tminclude\\ -->$\n|<\\?(?:php)?.*\\bend(if|for(each)?|while)\\b\n|\\{\\{?/(if|foreach|capture|literal|foreach|php|section|strip)\n|^[^{]*\\}\n)";
const keyEquivalent = "^~H";
const name = "astro";
const scopeName = "text.html.astro";
const patterns = [
	{
		include: "#astro-markdown"
	},
	{
		include: "#astro-expressions"
	},
	{
		begin: "(<)([a-zA-Z0-9:-]++)(?=[^>]*></\\2>)",
		beginCaptures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.html"
			}
		},
		end: "(>)(<)(/)(\\2)(>)",
		endCaptures: {
			"1": {
				name: "punctuation.definition.tag.end.html"
			},
			"2": {
				name: "punctuation.definition.tag.begin.html meta.scope.between-tag-pair.html"
			},
			"3": {
				name: "punctuation.definition.tag.begin.html"
			},
			"4": {
				name: "entity.name.tag.html"
			},
			"5": {
				name: "punctuation.definition.tag.end.html"
			}
		},
		name: "meta.tag.any.html",
		patterns: [
			{
				include: "#tag-stuff"
			}
		]
	},
	{
		begin: "(<\\?)(xml)",
		captures: {
			"1": {
				name: "punctuation.definition.tag.html"
			},
			"2": {
				name: "entity.name.tag.xml.html"
			}
		},
		end: "(\\?>)",
		name: "meta.tag.preprocessor.xml.html",
		patterns: [
			{
				include: "#tag-generic-attribute"
			},
			{
				include: "#string-double-quoted"
			},
			{
				include: "#string-single-quoted"
			}
		]
	},
	{
		begin: "<!--",
		captures: {
			"0": {
				name: "punctuation.definition.comment.html"
			}
		},
		end: "--\\s*>",
		name: "comment.block.html",
		patterns: [
			{
				match: "--",
				name: "invalid.illegal.bad-comments-or-CDATA.html"
			}
		]
	},
	{
		begin: "<!",
		captures: {
			"0": {
				name: "punctuation.definition.tag.html"
			}
		},
		end: ">",
		name: "meta.tag.sgml.html",
		patterns: [
			{
				begin: "(?i:DOCTYPE|doctype)",
				captures: {
					"1": {
						name: "entity.name.tag.doctype.html"
					}
				},
				end: "(?=>)",
				name: "meta.tag.sgml.doctype.html",
				patterns: [
					{
						match: "\"[^\">]*\"",
						name: "string.quoted.double.doctype.identifiers-and-DTDs.html"
					}
				]
			},
			{
				begin: "\\[CDATA\\[",
				end: "]](?=>)",
				name: "constant.other.inline-data.html"
			},
			{
				match: "(\\s*)(?!--|>)\\S(\\s*)",
				name: "invalid.illegal.bad-comments-or-CDATA.html"
			}
		]
	},
	{
		begin: "(?:^\\s+)?(<)((?i:style))\\b(?=[^>]*lang=(['\"])css\\1?)",
		captures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.style.html"
			},
			"3": {
				name: "punctuation.definition.tag.html"
			}
		},
		end: "(</)((?i:style))(>)(?:\\s*\\n)?",
		name: "source.css.embedded.html",
		patterns: [
			{
				include: "#tag-stuff"
			},
			{
				begin: "(>)",
				beginCaptures: {
					"1": {
						name: "punctuation.definition.tag.end.html"
					}
				},
				end: "(?=</(?i:style))",
				patterns: [
					{
						include: "source.css"
					}
				]
			}
		]
	},
	{
		begin: "(?:^\\s+)?(<)((?i:style))\\b(?=[^>]*lang=(['\"])sass\\1?)",
		captures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.style.html"
			},
			"3": {
				name: "punctuation.definition.tag.html"
			}
		},
		end: "(</)((?i:style))(>)(?:\\s*\\n)?",
		name: "source.sass.embedded.html",
		patterns: [
			{
				include: "#tag-stuff"
			},
			{
				begin: "(>)",
				beginCaptures: {
					"1": {
						name: "punctuation.definition.tag.end.html"
					}
				},
				end: "(?=</(?i:style))",
				patterns: [
					{
						include: "source.sass"
					}
				]
			}
		]
	},
	{
		begin: "(?:^\\s+)?(<)((?i:style))\\b(?=[^>]*lang=(['\"])scss\\1?)",
		captures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.style.html"
			},
			"3": {
				name: "punctuation.definition.tag.html"
			}
		},
		end: "(</)((?i:style))(>)(?:\\s*\\n)?",
		name: "source.scss.embedded.html",
		patterns: [
			{
				include: "#tag-stuff"
			},
			{
				begin: "(>)",
				beginCaptures: {
					"1": {
						name: "punctuation.definition.tag.end.html"
					}
				},
				end: "(?=</(?i:style))",
				patterns: [
					{
						include: "source.css.scss"
					}
				]
			}
		]
	},
	{
		begin: "(?:^\\s+)?(<)((?i:style))\\b(?![^>]*/>)",
		captures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.style.html"
			},
			"3": {
				name: "punctuation.definition.tag.html"
			}
		},
		end: "(</)((?i:style))(>)(?:\\s*\\n)?",
		__DEFAULT_STYLE_NAME_START__: null,
		name: "source.css.embedded.html",
		__DEFAULT_STYLE_NAME_END__: null,
		patterns: [
			{
				include: "#tag-stuff"
			},
			{
				begin: "(>)",
				beginCaptures: {
					"1": {
						name: "punctuation.definition.tag.end.html"
					}
				},
				end: "(?=</(?i:style))",
				patterns: [
					{
						__DEFAULT_STYLE_INCLUDE_START__: null,
						include: "source.css",
						__DEFAULT_STYLE_INCLUDE_END__: null
					}
				]
			}
		]
	},
	{
		begin: "(?:^\\s+)?(<)((?i:script))\\b(?=[^>]*lang=(['\"])tsx\\1?)",
		beginCaptures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.script.html"
			}
		},
		end: "(?<=</(script|SCRIPT))(>)(?:\\s*\\n)?",
		endCaptures: {
			"2": {
				name: "punctuation.definition.tag.html"
			}
		},
		name: "source.tsx.embedded.html",
		patterns: [
			{
				include: "#tag-stuff"
			},
			{
				begin: "(?<!</(?:script|SCRIPT))(>)",
				captures: {
					"1": {
						name: "punctuation.definition.tag.begin.html"
					},
					"2": {
						name: "entity.name.tag.script.html"
					}
				},
				end: "(</)((?i:script))",
				patterns: [
					{
						include: "source.tsx"
					}
				]
			}
		]
	},
	{
		begin: "(?:^\\s+)?(<)((?i:script))\\b(?=[^>]*lang=(['\"])ts\\1?)",
		beginCaptures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.script.html"
			}
		},
		end: "(?<=</(script|SCRIPT))(>)(?:\\s*\\n)?",
		endCaptures: {
			"2": {
				name: "punctuation.definition.tag.html"
			}
		},
		name: "source.tsx.embedded.html",
		patterns: [
			{
				include: "#tag-stuff"
			},
			{
				begin: "(?<!</(?:script|SCRIPT))(>)",
				captures: {
					"1": {
						name: "punctuation.definition.tag.begin.html"
					},
					"2": {
						name: "entity.name.tag.script.html"
					}
				},
				end: "(</)((?i:script))",
				patterns: [
					{
						include: "source.tsx"
					}
				]
			}
		]
	},
	{
		begin: "(<)((?i:script))\\b(?![^>]*/>)(?![^>]*(?i:type.?=.?text/((?!javascript|babel|ecmascript).*)))",
		beginCaptures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.script.html"
			}
		},
		end: "(?<=</(script|SCRIPT))(>)(?:\\s*\\n)?",
		endCaptures: {
			"2": {
				name: "punctuation.definition.tag.html"
			}
		},
		name: "source.tsx.embedded.html",
		patterns: [
			{
				include: "#tag-stuff"
			},
			{
				begin: "(?<!</(?:script|SCRIPT))(>)",
				captures: {
					"1": {
						name: "punctuation.definition.tag.begin.html"
					},
					"2": {
						name: "entity.name.tag.script.html"
					}
				},
				end: "(</)((?i:script))",
				patterns: [
					{
						captures: {
							"1": {
								name: "punctuation.definition.comment.js"
							}
						},
						match: "(//).*?((?=</script)|$\\n?)",
						name: "comment.line.double-slash.js"
					},
					{
						begin: "/\\*",
						captures: {
							"0": {
								name: "punctuation.definition.comment.js"
							}
						},
						end: "\\*/|(?=</script)",
						name: "comment.block.js"
					},
					{
						include: "source.tsx"
					}
				]
			}
		]
	},
	{
		begin: "(</?)((?i:body|head|html)\\b)",
		captures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.structure.any.html"
			}
		},
		end: "(>)",
		endCaptures: {
			"1": {
				name: "punctuation.definition.tag.end.html"
			}
		},
		name: "meta.tag.structure.any.html",
		patterns: [
			{
				include: "#tag-stuff"
			}
		]
	},
	{
		begin: "(</?)((?i:address|blockquote|dd|div|dl|dt|fieldset|form|frame|frameset|h1|h2|h3|h4|h5|h6|iframe|noframes|object|ol|p|ul|applet|center|dir|hr|menu|pre)\\b)",
		beginCaptures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.block.any.html"
			}
		},
		end: "(>)",
		endCaptures: {
			"1": {
				name: "punctuation.definition.tag.end.html"
			}
		},
		name: "meta.tag.block.any.html",
		patterns: [
			{
				include: "#tag-stuff"
			}
		]
	},
	{
		begin: "(</?)((?i:a|abbr|acronym|area|b|base|basefont|bdo|big|br|button|caption|cite|code|col|colgroup|del|dfn|em|font|head|html|i|img|input|ins|isindex|kbd|label|legend|li|link|map|meta|noscript|optgroup|option|param|q|s|samp|script|select|small|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|title|tr|tt|u|var)\\b)",
		beginCaptures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.inline.any.html"
			}
		},
		end: "((?: ?/)?>)",
		endCaptures: {
			"1": {
				name: "punctuation.definition.tag.end.html"
			}
		},
		name: "meta.tag.inline.any.html",
		patterns: [
			{
				include: "#tag-stuff"
			}
		]
	},
	{
		begin: "(</?)([A-Z][a-zA-Z0-9-\\.]*|[a-z]+\\.[a-zA-Z0-9-]+)(\\:(load|idle|visible))?",
		beginCaptures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.component.astro"
			},
			"3": {
				name: "keyword.control.loading.astro"
			}
		},
		end: "(/?>)",
		endCaptures: {
			"1": {
				name: "punctuation.definition.tag.end.html"
			}
		},
		name: "meta.tag.component.astro",
		patterns: [
			{
				include: "#tag-stuff"
			}
		]
	},
	{
		begin: "(</?)([a-zA-Z0-9:-]+)",
		beginCaptures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.other.html"
			}
		},
		end: "(/?>)",
		endCaptures: {
			"1": {
				name: "punctuation.definition.tag.end.html"
			}
		},
		name: "meta.tag.other.html",
		patterns: [
			{
				include: "#tag-stuff"
			}
		]
	},
	{
		include: "#entities"
	},
	{
		include: "#frontmatter"
	},
	{
		match: "<>",
		name: "invalid.illegal.incomplete.html"
	},
	{
		match: "<",
		name: "invalid.illegal.bad-angle-bracket.html"
	}
];
const repository = {
	frontmatter: {
		begin: "\\A(-{3})\\s*$",
		beginCaptures: {
			"1": {
				name: "comment.block.html"
			}
		},
		contentName: "meta.embedded.block.frontmatter",
		patterns: [
			{
				include: "source.tsx"
			}
		],
		end: "(^|\\G)(-{3})|\\.{3}\\s*$",
		endCaptures: {
			"2": {
				name: "comment.block.html"
			}
		}
	},
	entities: {
		patterns: [
			{
				captures: {
					"1": {
						name: "punctuation.definition.entity.html"
					},
					"3": {
						name: "punctuation.definition.entity.html"
					}
				},
				match: "(&)([a-zA-Z0-9]+|#[0-9]+|#x[0-9a-fA-F]+)(;)",
				name: "constant.character.entity.html"
			},
			{
				match: "&",
				name: "invalid.illegal.bad-ampersand.html"
			}
		]
	},
	"string-double-quoted": {
		begin: "\"",
		beginCaptures: {
			"0": {
				name: "punctuation.definition.string.begin.html"
			}
		},
		end: "\"",
		endCaptures: {
			"0": {
				name: "punctuation.definition.string.end.html"
			}
		},
		name: "string.quoted.double.html",
		patterns: [
			{
				include: "#entities"
			}
		]
	},
	"string-single-quoted": {
		begin: "'",
		beginCaptures: {
			"0": {
				name: "punctuation.definition.string.begin.html"
			}
		},
		end: "'",
		endCaptures: {
			"0": {
				name: "punctuation.definition.string.end.html"
			}
		},
		name: "string.quoted.single.html",
		patterns: [
			{
				include: "#entities"
			}
		]
	},
	"tag-generic-attribute": {
		match: "\\b([a-zA-Z\\-:]+)",
		name: "entity.other.attribute-name.html"
	},
	"tag-id-attribute": {
		begin: "\\b(id)\\b\\s*(=)",
		captures: {
			"1": {
				name: "entity.other.attribute-name.id.html"
			},
			"2": {
				name: "punctuation.separator.key-value.html"
			}
		},
		end: "(?<='|\")",
		name: "meta.attribute-with-value.id.html",
		patterns: [
			{
				begin: "\"",
				beginCaptures: {
					"0": {
						name: "punctuation.definition.string.begin.html"
					}
				},
				contentName: "meta.toc-list.id.html",
				end: "\"",
				endCaptures: {
					"0": {
						name: "punctuation.definition.string.end.html"
					}
				},
				name: "string.quoted.double.html",
				patterns: [
					{
						include: "#astro-expressions"
					},
					{
						include: "#entities"
					}
				]
			},
			{
				begin: "'",
				beginCaptures: {
					"0": {
						name: "punctuation.definition.string.begin.html"
					}
				},
				contentName: "meta.toc-list.id.html",
				end: "'",
				endCaptures: {
					"0": {
						name: "punctuation.definition.string.end.html"
					}
				},
				name: "string.quoted.single.html",
				patterns: [
					{
						include: "#astro-expressions"
					},
					{
						include: "#entities"
					}
				]
			}
		]
	},
	"tag-stuff": {
		patterns: [
			{
				include: "#tag-id-attribute"
			},
			{
				include: "#tag-generic-attribute"
			},
			{
				include: "#string-double-quoted"
			},
			{
				include: "#string-single-quoted"
			},
			{
				include: "#astro-load-directive"
			},
			{
				include: "#astro-expressions"
			},
			{
				include: "#astro-markdown"
			}
		]
	},
	"astro-markdown": {
		name: "text.html.astro.markdown",
		begin: "(<)(Markdown)(>)",
		beginCaptures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.html"
			},
			"3": {
				name: "punctuation.definition.tag.end.html"
			}
		},
		end: "(</)(Markdown)(>)",
		endCaptures: {
			"1": {
				name: "punctuation.definition.tag.begin.html"
			},
			"2": {
				name: "entity.name.tag.html"
			},
			"3": {
				name: "punctuation.definition.tag.end.html"
			}
		},
		patterns: [
			{
				include: "text.html.markdown.astro"
			}
		]
	},
	"astro-expressions": {
		patterns: [
			{
				begin: "\\{",
				beginCaptures: {
					"0": {
						name: "punctuation.definition.generic.begin.html"
					}
				},
				end: "\\}",
				endCaptures: {
					"0": {
						name: "punctuation.definition.generic.end.html"
					}
				},
				name: "expression.embbeded.astro",
				patterns: [
					{
						include: "source.tsx"
					}
				]
			}
		]
	}
};
const astro_tmLanguage = {
	$schema: $schema,
	fileTypes: fileTypes,
	foldingStartMarker: foldingStartMarker,
	foldingStopMarker: foldingStopMarker,
	keyEquivalent: keyEquivalent,
	name: name,
	scopeName: scopeName,
	patterns: patterns,
	repository: repository
};

export { $schema, astro_tmLanguage as default, fileTypes, foldingStartMarker, foldingStopMarker, keyEquivalent, name, patterns, repository, scopeName };
