const information_for_contributors = [
	"This file has been converted from https://github.com/jlelong/vscode-latex-basics/blob/master/syntaxes/Bibtex.tmLanguage.json",
	"If you want to provide a fix or improvement, please create a pull request against the original repository.",
	"Once accepted there, we are happy to receive an update request."
];
const version = "https://github.com/jlelong/vscode-latex-basics/commit/45cf7d1b88b959dcb16bccf60da7ef4494c1acc9";
const name = "bibtex";
const scopeName = "text.bibtex";
const comment = "Grammar based on description from http://artis.imag.fr/~Xavier.Decoret/resources/xdkbibtex/bibtex_summary.html#comment\n\t\n\tTODO: Does not support @preamble\n\t";
const patterns = [
	{
		begin: "@Comment",
		beginCaptures: {
			"0": {
				name: "punctuation.definition.comment.bibtex"
			}
		},
		end: "$\\n?",
		name: "comment.line.at-sign.bibtex"
	},
	{
		begin: "((@)(?i:string))\\s*(\\{)\\s*([a-zA-Z]*)",
		beginCaptures: {
			"1": {
				name: "keyword.other.string-constant.bibtex"
			},
			"2": {
				name: "punctuation.definition.keyword.bibtex"
			},
			"3": {
				name: "punctuation.section.string-constant.begin.bibtex"
			},
			"4": {
				name: "variable.other.bibtex"
			}
		},
		end: "\\}",
		endCaptures: {
			"0": {
				name: "punctuation.section.string-constant.end.bibtex"
			}
		},
		name: "meta.string-constant.braces.bibtex",
		patterns: [
			{
				include: "#string_content"
			}
		]
	},
	{
		begin: "((@)i(?i::string))\\s*(\\()\\s*([a-zA-Z]*)",
		beginCaptures: {
			"1": {
				name: "keyword.other.string-constant.bibtex"
			},
			"2": {
				name: "punctuation.definition.keyword.bibtex"
			},
			"3": {
				name: "punctuation.section.string-constant.begin.bibtex"
			},
			"4": {
				name: "variable.other.bibtex"
			}
		},
		end: "\\)",
		endCaptures: {
			"0": {
				name: "punctuation.section.string-constant.end.bibtex"
			}
		},
		name: "meta.string-constant.parenthesis.bibtex",
		patterns: [
			{
				include: "#string_content"
			}
		]
	},
	{
		begin: "((@)[a-zA-Z]+)\\s*(\\{)\\s*([^\\s,]*)",
		beginCaptures: {
			"1": {
				name: "keyword.other.entry-type.bibtex"
			},
			"2": {
				name: "punctuation.definition.keyword.bibtex"
			},
			"3": {
				name: "punctuation.section.entry.begin.bibtex"
			},
			"4": {
				name: "entity.name.type.entry-key.bibtex"
			}
		},
		end: "\\}",
		endCaptures: {
			"0": {
				name: "punctuation.section.entry.end.bibtex"
			}
		},
		name: "meta.entry.braces.bibtex",
		patterns: [
			{
				begin: "([a-zA-Z0-9\\!\\$\\&\\*\\+\\-\\.\\/\\:\\;\\<\\>\\?\\[\\]\\^\\_\\`\\|]+)\\s*(\\=)",
				beginCaptures: {
					"1": {
						name: "support.function.key.bibtex"
					},
					"2": {
						name: "punctuation.separator.key-value.bibtex"
					}
				},
				end: "(?=[,}])",
				name: "meta.key-assignment.bibtex",
				patterns: [
					{
						include: "#string_var"
					},
					{
						include: "#string_content"
					},
					{
						include: "#integer"
					}
				]
			}
		]
	},
	{
		begin: "((@)[a-zA-Z]+)\\s*(\\()\\s*([^\\s,]*)",
		beginCaptures: {
			"1": {
				name: "keyword.other.entry-type.bibtex"
			},
			"2": {
				name: "punctuation.definition.keyword.bibtex"
			},
			"3": {
				name: "punctuation.section.entry.begin.bibtex"
			},
			"4": {
				name: "entity.name.type.entry-key.bibtex"
			}
		},
		end: "\\)",
		endCaptures: {
			"0": {
				name: "punctuation.section.entry.end.bibtex"
			}
		},
		name: "meta.entry.parenthesis.bibtex",
		patterns: [
			{
				begin: "([a-zA-Z0-9\\!\\$\\&\\*\\+\\-\\.\\/\\:\\;\\<\\>\\?\\[\\]\\^\\_\\`\\|]+)\\s*(\\=)",
				beginCaptures: {
					"1": {
						name: "support.function.key.bibtex"
					},
					"2": {
						name: "punctuation.separator.key-value.bibtex"
					}
				},
				end: "(?=[,)])",
				name: "meta.key-assignment.bibtex",
				patterns: [
					{
						include: "#string_var"
					},
					{
						include: "#string_content"
					},
					{
						include: "#integer"
					}
				]
			}
		]
	},
	{
		begin: "[^@\\n]",
		end: "(?=@)",
		name: "comment.block.bibtex"
	}
];
const repository = {
	integer: {
		match: "\\d+",
		name: "constant.numeric.bibtex"
	},
	nested_braces: {
		begin: "(?<!\\\\)\\{",
		beginCaptures: {
			"0": {
				name: "punctuation.definition.group.begin.bibtex"
			}
		},
		end: "(?<!\\\\)\\}",
		endCaptures: {
			"0": {
				name: "punctuation.definition.group.end.bibtex"
			}
		},
		patterns: [
			{
				include: "#nested_braces"
			}
		]
	},
	string_var: {
		match: "(#)?\\s*([a-zA-Z]+)\\s*(#)?",
		captures: {
			"1": {
				name: "keyword.operator.bibtex"
			},
			"2": {
				name: "support.variable.bibtex"
			},
			"3": {
				name: "keyword.operator.bibtex"
			}
		}
	},
	string_content: {
		patterns: [
			{
				begin: "\\{",
				beginCaptures: {
					"0": {
						name: "punctuation.definition.string.begin.bibtex"
					}
				},
				end: "(\\})(?=(?:,?\\s*\\}?\\s*\\n)|(?:\\s*#))",
				endCaptures: {
					"1": {
						name: "punctuation.definition.string.end.bibtex"
					}
				},
				patterns: [
					{
						match: "@",
						name: "invalid.illegal.at-sign.bibtex"
					},
					{
						include: "#nested_braces"
					}
				]
			},
			{
				begin: "\"",
				beginCaptures: {
					"0": {
						name: "punctuation.definition.string.begin.bibtex"
					}
				},
				end: "\"(?=(?:,?\\s*\\}?\\s*\\n)|(?:\\s*#))",
				endCaptures: {
					"0": {
						name: "punctuation.definition.string.end.bibtex"
					}
				},
				patterns: [
					{
						match: "@",
						name: "invalid.illegal.at-sign.bibtex"
					}
				]
			}
		]
	}
};
const bibtex_tmLanguage = {
	information_for_contributors: information_for_contributors,
	version: version,
	name: name,
	scopeName: scopeName,
	comment: comment,
	patterns: patterns,
	repository: repository
};

export { comment, bibtex_tmLanguage as default, information_for_contributors, name, patterns, repository, scopeName, version };
