const $schema = "https://raw.githubusercontent.com/martinring/tmlanguage/master/tmlanguage.json";
const name = "bicep";
const scopeName = "source.bicep";
const fileTypes = [
	".bicep"
];
const patterns = [
	{
		include: "#expression"
	},
	{
		include: "#comments"
	}
];
const repository = {
	"array-literal": {
		name: "meta.array-literal.bicep",
		begin: "\\[(?!(?:[ \\t\\r\\n]|\\/\\*(?:\\*(?!\\/)|[^*])*\\*\\/)*\\bfor\\b)",
		end: "]",
		patterns: [
			{
				include: "#expression"
			},
			{
				include: "#comments"
			}
		]
	},
	"block-comment": {
		name: "comment.block.bicep",
		begin: "/\\*",
		end: "\\*/"
	},
	comments: {
		patterns: [
			{
				include: "#line-comment"
			},
			{
				include: "#block-comment"
			}
		]
	},
	decorator: {
		name: "meta.decorator.bicep",
		begin: "@(?:[ \\t\\r\\n]|\\/\\*(?:\\*(?!\\/)|[^*])*\\*\\/)*(?=\\b[_$[:alpha:]][_$[:alnum:]]*\\b)",
		end: "",
		patterns: [
			{
				include: "#expression"
			},
			{
				include: "#comments"
			}
		]
	},
	"escape-character": {
		name: "constant.character.escape.bicep",
		match: "\\\\(u{[0-9A-Fa-f]+}|n|r|t|\\\\|'|\\${)"
	},
	expression: {
		patterns: [
			{
				include: "#string-literal"
			},
			{
				include: "#string-verbatim"
			},
			{
				include: "#numeric-literal"
			},
			{
				include: "#named-literal"
			},
			{
				include: "#object-literal"
			},
			{
				include: "#array-literal"
			},
			{
				include: "#keyword"
			},
			{
				include: "#identifier"
			},
			{
				include: "#function-call"
			},
			{
				include: "#decorator"
			}
		]
	},
	"function-call": {
		name: "meta.function-call.bicep",
		begin: "(\\b[_$[:alpha:]][_$[:alnum:]]*\\b)(?:[ \\t\\r\\n]|\\/\\*(?:\\*(?!\\/)|[^*])*\\*\\/)*\\(",
		beginCaptures: {
			"1": {
				name: "entity.name.function.bicep"
			}
		},
		end: "\\)",
		patterns: [
			{
				include: "#expression"
			},
			{
				include: "#comments"
			}
		]
	},
	identifier: {
		name: "variable.other.readwrite.bicep",
		match: "\\b[_$[:alpha:]][_$[:alnum:]]*\\b(?!(?:[ \\t\\r\\n]|\\/\\*(?:\\*(?!\\/)|[^*])*\\*\\/)*\\()"
	},
	keyword: {
		name: "keyword.control.declaration.bicep",
		match: "\\b(targetScope|resource|module|param|var|output|for|in|if|existing|import|from)\\b"
	},
	"line-comment": {
		name: "comment.line.double-slash.bicep",
		match: "//.*(?=$)"
	},
	"named-literal": {
		name: "constant.language.bicep",
		match: "\\b(true|false|null)\\b"
	},
	"numeric-literal": {
		name: "constant.numeric.bicep",
		match: "[0-9]+"
	},
	"object-literal": {
		name: "meta.object-literal.bicep",
		begin: "{",
		end: "}",
		patterns: [
			{
				include: "#object-property"
			},
			{
				include: "#comments"
			}
		]
	},
	"object-property": {
		name: "meta.object-property.bicep",
		begin: "(?<=^)(?!(?:[ \\t\\r\\n]|\\/\\*(?:\\*(?!\\/)|[^*])*\\*\\/)*})",
		end: "(?=$)",
		patterns: [
			{
				include: "#object-property-key-identifier"
			},
			{
				include: "#string-literal"
			},
			{
				include: "#object-property-end"
			},
			{
				include: "#comments"
			}
		]
	},
	"object-property-end": {
		name: "meta.object-property-end.bicep",
		begin: ":((?:[ \\t\\r\\n]|\\/\\*(?:\\*(?!\\/)|[^*])*\\*\\/)*)",
		beginCaptures: {
			"1": {
				patterns: [
					{
						include: "#line-comment"
					},
					{
						include: "#block-comment"
					}
				]
			}
		},
		end: "(?=(?:[ \\t\\r\\n]|\\/\\*(?:\\*(?!\\/)|[^*])*\\*\\/)*$)",
		patterns: [
			{
				include: "#expression"
			},
			{
				include: "#comments"
			}
		]
	},
	"object-property-key-identifier": {
		name: "meta.object-property-key-identifier.bicep",
		match: "(\\b[_$[:alpha:]][_$[:alnum:]]*\\b)",
		captures: {
			"1": {
				name: "variable.other.property.bicep"
			}
		}
	},
	"string-literal": {
		name: "string.quoted.single.bicep",
		begin: "'(?!'')",
		end: "'",
		patterns: [
			{
				include: "#escape-character"
			},
			{
				include: "#string-literal-subst"
			}
		]
	},
	"string-literal-subst": {
		name: "meta.string-literal-subst.bicep",
		begin: "(?<!\\\\)(\\${)",
		beginCaptures: {
			"1": {
				name: "punctuation.definition.template-expression.begin.bicep"
			}
		},
		end: "(})",
		endCaptures: {
			"1": {
				name: "punctuation.definition.template-expression.end.bicep"
			}
		},
		patterns: [
			{
				include: "#expression"
			},
			{
				include: "#comments"
			}
		]
	},
	"string-verbatim": {
		name: "string.quoted.multi.bicep",
		begin: "'''",
		end: "'''",
		patterns: [
		]
	}
};
const bicep_tmLanguage = {
	$schema: $schema,
	name: name,
	scopeName: scopeName,
	fileTypes: fileTypes,
	patterns: patterns,
	repository: repository
};

export { $schema, bicep_tmLanguage as default, fileTypes, name, patterns, repository, scopeName };
