const information_for_contributors = [
	"This file has been converted from https://github.com/textmate/git.tmbundle/blob/master/Syntaxes/Git%20Commit%20Message.tmLanguage",
	"If you want to provide a fix or improvement, please create a pull request against the original repository.",
	"Once accepted there, we are happy to receive an update request."
];
const version = "https://github.com/textmate/git.tmbundle/commit/93897a78c6e52bef13dadc0d4091d203c5facb40";
const name = "git-commit";
const scopeName = "text.git-commit";
const patterns = [
	{
		begin: "\\A(?!# Please enter the commit message)",
		end: "^(?=# Please enter the commit message)",
		name: "meta.scope.message.git-commit",
		patterns: [
			{
				begin: "\\A(?=#)",
				end: "^(?!#)",
				patterns: [
					{
						include: "#comment"
					}
				]
			},
			{
				begin: "^(?!# Please enter the commit message)",
				end: "^(?=# Please enter the commit message)",
				patterns: [
					{
						begin: "\\G",
						end: "^(?!\\G)",
						name: "meta.scope.subject.git-commit",
						patterns: [
							{
								captures: {
									"1": {
										name: "keyword.other.$2.git-commit"
									}
								},
								match: "\\G((fixup|squash)!)\\s*"
							},
							{
								match: ".{73,}$",
								name: "invalid.illegal.line-too-long.git-commit"
							},
							{
								match: ".{51,}$",
								name: "invalid.deprecated.line-too-long.git-commit"
							}
						]
					},
					{
						begin: "^(?!# Please enter the commit message)",
						end: "^(?=# Please enter the commit message)",
						patterns: [
							{
								include: "#comment"
							}
						]
					}
				]
			}
		]
	},
	{
		begin: "^(?=# Please enter the commit message)",
		end: "\\z",
		name: "meta.scope.metadata.git-commit",
		patterns: [
			{
				include: "#metadata"
			}
		]
	}
];
const repository = {
	comment: {
		begin: "^(#)",
		captures: {
			"1": {
				name: "punctuation.definition.comment.git-commit"
			}
		},
		end: "\\n",
		name: "comment.line.number-sign.git-commit"
	},
	metadata: {
		patterns: [
			{
				begin: "(?=^# Changes to be committed:)",
				end: "(?!\\G)((?=^# \\w)|(?!^#))",
				patterns: [
					{
						begin: "(^[ \\t]+)?(?=#)",
						beginCaptures: {
							"1": {
								name: "punctuation.whitespace.comment.leading.git-commit"
							}
						},
						contentName: "comment.line.number-sign.git-commit",
						end: "(?!\\G)^",
						patterns: [
							{
								match: "\\G#",
								name: "punctuation.definition.comment.git-commit"
							},
							{
								match: "((modified|renamed):.*)$\\n?",
								name: "markup.changed.git-commit"
							},
							{
								match: "(new file:.*)$\\n?",
								name: "markup.inserted.git-commit"
							},
							{
								match: "(deleted:.*)$\\n?",
								name: "markup.deleted.git-commit"
							}
						]
					}
				]
			},
			{
				include: "#comment"
			},
			{
				begin: "(?=diff\\ \\-\\-git)",
				comment: "diff presented at the end of the commit message when using commit -v.",
				contentName: "source.diff",
				end: "\\z",
				name: "meta.embedded.diff.git-commit",
				patterns: [
					{
						include: "source.diff"
					}
				]
			}
		]
	}
};
const gitCommit_tmLanguage = {
	information_for_contributors: information_for_contributors,
	version: version,
	name: name,
	scopeName: scopeName,
	patterns: patterns,
	repository: repository
};

export { gitCommit_tmLanguage as default, information_for_contributors, name, patterns, repository, scopeName, version };
