const name = "github-light";
const colors = {
	focusBorder: "#0969da",
	foreground: "#24292f",
	descriptionForeground: "#57606a",
	errorForeground: "#cf222e",
	"textLink.foreground": "#0969da",
	"textLink.activeForeground": "#0969da",
	"textBlockQuote.background": "#f6f8fa",
	"textBlockQuote.border": "#d0d7de",
	"textCodeBlock.background": "#afb8c133",
	"textPreformat.foreground": "#57606a",
	"textSeparator.foreground": "#d8dee4",
	"button.background": "#2da44e",
	"button.foreground": "#ffffff",
	"button.hoverBackground": "#2c974b",
	"button.secondaryBackground": "#ebecf0",
	"button.secondaryForeground": "#24292f",
	"button.secondaryHoverBackground": "#f3f4f6",
	"checkbox.background": "#f6f8fa",
	"checkbox.border": "#d0d7de",
	"dropdown.background": "#ffffff",
	"dropdown.border": "#d0d7de",
	"dropdown.foreground": "#24292f",
	"dropdown.listBackground": "#ffffff",
	"input.background": "#ffffff",
	"input.border": "#d0d7de",
	"input.foreground": "#24292f",
	"input.placeholderForeground": "#6e7781",
	"badge.foreground": "#ffffff",
	"badge.background": "#0969da",
	"progressBar.background": "#0969da",
	"titleBar.activeForeground": "#57606a",
	"titleBar.activeBackground": "#ffffff",
	"titleBar.inactiveForeground": "#57606a",
	"titleBar.inactiveBackground": "#f6f8fa",
	"titleBar.border": "#d0d7de",
	"activityBar.foreground": "#24292f",
	"activityBar.inactiveForeground": "#57606a",
	"activityBar.background": "#ffffff",
	"activityBarBadge.foreground": "#ffffff",
	"activityBarBadge.background": "#0969da",
	"activityBar.activeBorder": "#fd8c73",
	"activityBar.border": "#d0d7de",
	"sideBar.foreground": "#24292f",
	"sideBar.background": "#f6f8fa",
	"sideBar.border": "#d0d7de",
	"sideBarTitle.foreground": "#24292f",
	"sideBarSectionHeader.foreground": "#24292f",
	"sideBarSectionHeader.background": "#f6f8fa",
	"sideBarSectionHeader.border": "#d0d7de",
	"list.hoverForeground": "#24292f",
	"list.inactiveSelectionForeground": "#24292f",
	"list.activeSelectionForeground": "#24292f",
	"list.hoverBackground": "#eaeef280",
	"list.inactiveSelectionBackground": "#afb8c133",
	"list.activeSelectionBackground": "#afb8c133",
	"list.focusForeground": "#24292f",
	"list.focusBackground": "#ddf4ff",
	"list.inactiveFocusBackground": "#ddf4ff",
	"list.highlightForeground": "#0969da",
	"tree.indentGuidesStroke": "#d8dee4",
	"notificationCenterHeader.foreground": "#57606a",
	"notificationCenterHeader.background": "#f6f8fa",
	"notifications.foreground": "#24292f",
	"notifications.background": "#ffffff",
	"notifications.border": "#d0d7de",
	"notificationsErrorIcon.foreground": "#cf222e",
	"notificationsWarningIcon.foreground": "#9a6700",
	"notificationsInfoIcon.foreground": "#0969da",
	"pickerGroup.border": "#d0d7de",
	"pickerGroup.foreground": "#57606a",
	"quickInput.background": "#ffffff",
	"quickInput.foreground": "#24292f",
	"statusBar.foreground": "#57606a",
	"statusBar.background": "#ffffff",
	"statusBar.border": "#d0d7de",
	"statusBar.noFolderBackground": "#ffffff",
	"statusBar.debuggingBackground": "#cf222e",
	"statusBar.debuggingForeground": "#ffffff",
	"statusBarItem.prominentBackground": "#f6f8fa",
	"editorGroupHeader.tabsBackground": "#f6f8fa",
	"editorGroupHeader.tabsBorder": "#d0d7de",
	"editorGroup.border": "#d0d7de",
	"tab.activeForeground": "#24292f",
	"tab.inactiveForeground": "#57606a",
	"tab.inactiveBackground": "#f6f8fa",
	"tab.activeBackground": "#ffffff",
	"tab.hoverBackground": "#ffffff",
	"tab.unfocusedHoverBackground": "#eaeef280",
	"tab.border": "#d0d7de",
	"tab.unfocusedActiveBorderTop": "#d0d7de",
	"tab.activeBorder": "#ffffff",
	"tab.unfocusedActiveBorder": "#ffffff",
	"tab.activeBorderTop": "#fd8c73",
	"breadcrumb.foreground": "#57606a",
	"breadcrumb.focusForeground": "#24292f",
	"breadcrumb.activeSelectionForeground": "#57606a",
	"breadcrumbPicker.background": "#ffffff",
	"editor.foreground": "#24292f",
	"editor.background": "#ffffff",
	"editorWidget.background": "#ffffff",
	"editor.foldBackground": "#6e77811a",
	"editor.lineHighlightBackground": "#eaeef280",
	"editorLineNumber.foreground": "#57606a",
	"editorLineNumber.activeForeground": "#24292f",
	"editorIndentGuide.background": "#d8dee4",
	"editorIndentGuide.activeBackground": "#d0d7de",
	"editorWhitespace.foreground": "#6e7781",
	"editorCursor.foreground": "#0969da",
	"editor.findMatchBackground": "#bf8700",
	"editor.findMatchHighlightBackground": "#ffdf5d66",
	"editor.linkedEditingBackground": "#0366d611",
	"editor.inactiveSelectionBackground": "#0366d611",
	"editor.selectionBackground": "#0366d625",
	"editor.selectionHighlightBackground": "#34d05840",
	"editor.selectionHighlightBorder": "#34d05800",
	"editor.wordHighlightBackground": "#34d05800",
	"editor.wordHighlightStrongBackground": "#34d05800",
	"editor.wordHighlightBorder": "#24943e99",
	"editor.wordHighlightStrongBorder": "#24943e50",
	"editorBracketMatch.background": "#34d05840",
	"editorBracketMatch.border": "#34d05800",
	"editorGutter.modifiedBackground": "#d4a72c66",
	"editorGutter.addedBackground": "#4ac26b66",
	"editorGutter.deletedBackground": "#ff818266",
	"diffEditor.insertedTextBackground": "#dafbe1",
	"diffEditor.removedTextBackground": "#ffebe9",
	"scrollbar.shadow": "#6a737d33",
	"scrollbarSlider.background": "#959da533",
	"scrollbarSlider.hoverBackground": "#959da544",
	"scrollbarSlider.activeBackground": "#959da588",
	"editorOverviewRuler.border": "#ffffff",
	"panel.background": "#f6f8fa",
	"panel.border": "#d0d7de",
	"panelTitle.activeBorder": "#fd8c73",
	"panelTitle.activeForeground": "#24292f",
	"panelTitle.inactiveForeground": "#57606a",
	"panelInput.border": "#d0d7de",
	"terminal.foreground": "#57606a",
	"terminal.ansiBlack": "#24292f",
	"terminal.ansiRed": "#cf222e",
	"terminal.ansiGreen": "#116329",
	"terminal.ansiYellow": "#4d2d00",
	"terminal.ansiBlue": "#0969da",
	"terminal.ansiMagenta": "#8250df",
	"terminal.ansiCyan": "#1b7c83",
	"terminal.ansiWhite": "#6e7781",
	"terminal.ansiBrightBlack": "#57606a",
	"terminal.ansiBrightRed": "#a40e26",
	"terminal.ansiBrightGreen": "#1a7f37",
	"terminal.ansiBrightYellow": "#633c01",
	"terminal.ansiBrightBlue": "#218bff",
	"terminal.ansiBrightMagenta": "#a475f9",
	"terminal.ansiBrightCyan": "#3192aa",
	"terminal.ansiBrightWhite": "#8c959f",
	"gitDecoration.addedResourceForeground": "#1a7f37",
	"gitDecoration.modifiedResourceForeground": "#9a6700",
	"gitDecoration.deletedResourceForeground": "#cf222e",
	"gitDecoration.untrackedResourceForeground": "#1a7f37",
	"gitDecoration.ignoredResourceForeground": "#6e7781",
	"gitDecoration.conflictingResourceForeground": "#bc4c00",
	"gitDecoration.submoduleResourceForeground": "#57606a",
	"debugToolBar.background": "#ffffff",
	"editor.stackFrameHighlightBackground": "#ffd33d33",
	"editor.focusedStackFrameHighlightBackground": "#28a74525",
	"settings.headerForeground": "#57606a",
	"settings.modifiedItemIndicator": "#d4a72c66",
	"welcomePage.buttonBackground": "#f6f8fa",
	"welcomePage.buttonHoverBackground": "#f3f4f6"
};
const semanticHighlighting = true;
const tokenColors = [
	{
		scope: [
			"comment",
			"punctuation.definition.comment",
			"string.comment"
		],
		settings: {
			foreground: "#6e7781"
		}
	},
	{
		scope: [
			"constant",
			"entity.name.constant",
			"variable.other.constant",
			"variable.language",
			"entity"
		],
		settings: {
			foreground: "#0550ae"
		}
	},
	{
		scope: [
			"entity.name",
			"meta.export.default",
			"meta.definition.variable"
		],
		settings: {
			foreground: "#953800"
		}
	},
	{
		scope: [
			"variable.parameter.function",
			"meta.jsx.children",
			"meta.block",
			"meta.tag.attributes",
			"entity.name.constant",
			"meta.object.member",
			"meta.embedded.expression"
		],
		settings: {
			foreground: "#24292f"
		}
	},
	{
		scope: "entity.name.function",
		settings: {
			foreground: "#8250df"
		}
	},
	{
		scope: [
			"entity.name.tag",
			"support.class.component"
		],
		settings: {
			foreground: "#116329"
		}
	},
	{
		scope: "keyword",
		settings: {
			foreground: "#cf222e"
		}
	},
	{
		scope: [
			"storage",
			"storage.type"
		],
		settings: {
			foreground: "#cf222e"
		}
	},
	{
		scope: [
			"storage.modifier.package",
			"storage.modifier.import",
			"storage.type.java"
		],
		settings: {
			foreground: "#24292f"
		}
	},
	{
		scope: [
			"string",
			"punctuation.definition.string",
			"string punctuation.section.embedded source"
		],
		settings: {
			foreground: "#0a3069"
		}
	},
	{
		scope: "support",
		settings: {
			foreground: "#0550ae"
		}
	},
	{
		scope: "meta.property-name",
		settings: {
			foreground: "#0550ae"
		}
	},
	{
		scope: "variable",
		settings: {
			foreground: "#953800"
		}
	},
	{
		scope: "variable.other",
		settings: {
			foreground: "#24292f"
		}
	},
	{
		scope: "invalid.broken",
		settings: {
			fontStyle: "italic",
			foreground: "#82071e"
		}
	},
	{
		scope: "invalid.deprecated",
		settings: {
			fontStyle: "italic",
			foreground: "#82071e"
		}
	},
	{
		scope: "invalid.illegal",
		settings: {
			fontStyle: "italic",
			foreground: "#82071e"
		}
	},
	{
		scope: "invalid.unimplemented",
		settings: {
			fontStyle: "italic",
			foreground: "#82071e"
		}
	},
	{
		scope: "carriage-return",
		settings: {
			fontStyle: "italic underline",
			background: "#cf222e",
			foreground: "#f6f8fa",
			content: "^M"
		}
	},
	{
		scope: "message.error",
		settings: {
			foreground: "#82071e"
		}
	},
	{
		scope: "string source",
		settings: {
			foreground: "#24292f"
		}
	},
	{
		scope: "string variable",
		settings: {
			foreground: "#0550ae"
		}
	},
	{
		scope: [
			"source.regexp",
			"string.regexp"
		],
		settings: {
			foreground: "#0a3069"
		}
	},
	{
		scope: [
			"string.regexp.character-class",
			"string.regexp constant.character.escape",
			"string.regexp source.ruby.embedded",
			"string.regexp string.regexp.arbitrary-repitition"
		],
		settings: {
			foreground: "#0a3069"
		}
	},
	{
		scope: "string.regexp constant.character.escape",
		settings: {
			fontStyle: "bold",
			foreground: "#116329"
		}
	},
	{
		scope: "support.constant",
		settings: {
			foreground: "#0550ae"
		}
	},
	{
		scope: "support.variable",
		settings: {
			foreground: "#0550ae"
		}
	},
	{
		scope: "meta.module-reference",
		settings: {
			foreground: "#0550ae"
		}
	},
	{
		scope: "punctuation.definition.list.begin.markdown",
		settings: {
			foreground: "#953800"
		}
	},
	{
		scope: [
			"markup.heading",
			"markup.heading entity.name"
		],
		settings: {
			fontStyle: "bold",
			foreground: "#0550ae"
		}
	},
	{
		scope: "markup.quote",
		settings: {
			foreground: "#116329"
		}
	},
	{
		scope: "markup.italic",
		settings: {
			fontStyle: "italic",
			foreground: "#24292f"
		}
	},
	{
		scope: "markup.bold",
		settings: {
			fontStyle: "bold",
			foreground: "#24292f"
		}
	},
	{
		scope: "markup.raw",
		settings: {
			foreground: "#0550ae"
		}
	},
	{
		scope: [
			"markup.deleted",
			"meta.diff.header.from-file",
			"punctuation.definition.deleted"
		],
		settings: {
			background: "#FFEBE9",
			foreground: "#82071e"
		}
	},
	{
		scope: [
			"markup.inserted",
			"meta.diff.header.to-file",
			"punctuation.definition.inserted"
		],
		settings: {
			background: "#dafbe1",
			foreground: "#116329"
		}
	},
	{
		scope: [
			"markup.changed",
			"punctuation.definition.changed"
		],
		settings: {
			background: "#ffd8b5",
			foreground: "#953800"
		}
	},
	{
		scope: [
			"markup.ignored",
			"markup.untracked"
		],
		settings: {
			foreground: "#eaeef2",
			background: "#0550ae"
		}
	},
	{
		scope: "meta.diff.range",
		settings: {
			foreground: "#8250df",
			fontStyle: "bold"
		}
	},
	{
		scope: "meta.diff.header",
		settings: {
			foreground: "#0550ae"
		}
	},
	{
		scope: "meta.separator",
		settings: {
			fontStyle: "bold",
			foreground: "#0550ae"
		}
	},
	{
		scope: "meta.output",
		settings: {
			foreground: "#0550ae"
		}
	},
	{
		scope: [
			"brackethighlighter.tag",
			"brackethighlighter.curly",
			"brackethighlighter.round",
			"brackethighlighter.square",
			"brackethighlighter.angle",
			"brackethighlighter.quote"
		],
		settings: {
			foreground: "#57606a"
		}
	},
	{
		scope: "brackethighlighter.unmatched",
		settings: {
			foreground: "#82071e"
		}
	},
	{
		scope: [
			"constant.other.reference.link",
			"string.other.link"
		],
		settings: {
			foreground: "#0a3069",
			fontStyle: "underline"
		}
	}
];
const githubLight = {
	name: name,
	colors: colors,
	semanticHighlighting: semanticHighlighting,
	tokenColors: tokenColors
};

export { colors, githubLight as default, name, semanticHighlighting, tokenColors };
