const information_for_contributors = [
	"This file has been converted from https://github.com/textmate/lua.tmbundle/blob/master/Syntaxes/Lua.plist",
	"If you want to provide a fix or improvement, please create a pull request against the original repository.",
	"Once accepted there, we are happy to receive an update request."
];
const version = "https://github.com/textmate/lua.tmbundle/commit/8ae5641365b28f697121ba1133890e8d81f5b00e";
const name = "lua";
const scopeName = "source.lua";
const patterns = [
	{
		begin: "\\b(?:(local)\\s+)?(function)\\s*(?:\\s+([a-zA-Z_][a-zA-Z0-9_]*(?:([\\.:])[a-zA-Z_][a-zA-Z0-9_]*)?)\\s*)?(\\()",
		beginCaptures: {
			"1": {
				name: "storage.modifier.local.lua"
			},
			"2": {
				name: "keyword.control.lua"
			},
			"3": {
				name: "entity.name.function.lua"
			},
			"4": {
				name: "punctuation.separator.parameter.lua"
			},
			"5": {
				name: "punctuation.definition.parameters.begin.lua"
			}
		},
		end: "\\)",
		endCaptures: {
			"0": {
				name: "punctuation.definition.parameters.end.lua"
			}
		},
		name: "meta.function.lua",
		patterns: [
			{
				match: "[a-zA-Z_][a-zA-Z0-9_]*",
				name: "variable.parameter.function.lua"
			},
			{
				match: ",",
				name: "punctuation.separator.arguments.lua"
			}
		]
	},
	{
		match: "(?<![\\w\\d.])0[xX][0-9A-Fa-f]+(?![pPeE.0-9])",
		name: "constant.numeric.integer.hexadecimal.lua"
	},
	{
		match: "(?<![\\w\\d.])0[xX][0-9A-Fa-f]+(\\.[0-9A-Fa-f]+)?([eE]-?\\d*)?([pP][-+]\\d+)?",
		name: "constant.numeric.float.hexadecimal.lua"
	},
	{
		match: "(?<![\\w\\d.])\\d+(?![pPeE.0-9])",
		name: "constant.numeric.integer.lua"
	},
	{
		match: "(?<![\\w\\d.])\\d+(\\.\\d+)?([eE]-?\\d*)?",
		name: "constant.numeric.float.lua"
	},
	{
		begin: "'",
		beginCaptures: {
			"0": {
				name: "punctuation.definition.string.begin.lua"
			}
		},
		end: "'",
		endCaptures: {
			"0": {
				name: "punctuation.definition.string.end.lua"
			}
		},
		name: "string.quoted.single.lua",
		patterns: [
			{
				include: "#escaped_char"
			}
		]
	},
	{
		begin: "\"",
		beginCaptures: {
			"0": {
				name: "punctuation.definition.string.begin.lua"
			}
		},
		end: "\"",
		endCaptures: {
			"0": {
				name: "punctuation.definition.string.end.lua"
			}
		},
		name: "string.quoted.double.lua",
		patterns: [
			{
				include: "#escaped_char"
			}
		]
	},
	{
		begin: "(?<=\\.cdef)\\s*(\\[(=*)\\[)",
		beginCaptures: {
			"0": {
				name: "string.quoted.other.multiline.lua"
			},
			"1": {
				name: "punctuation.definition.string.begin.lua"
			}
		},
		contentName: "meta.embedded.lua",
		end: "(\\]\\2\\])",
		endCaptures: {
			"0": {
				name: "string.quoted.other.multiline.lua"
			},
			"1": {
				name: "punctuation.definition.string.end.lua"
			}
		},
		patterns: [
			{
				include: "source.c"
			}
		]
	},
	{
		begin: "(?<!--)\\[(=*)\\[",
		beginCaptures: {
			"0": {
				name: "punctuation.definition.string.begin.lua"
			}
		},
		end: "\\]\\1\\]",
		endCaptures: {
			"0": {
				name: "punctuation.definition.string.end.lua"
			}
		},
		name: "string.quoted.other.multiline.lua"
	},
	{
		captures: {
			"1": {
				name: "punctuation.definition.comment.lua"
			}
		},
		match: "\\A(#!).*$\\n?",
		name: "comment.line.shebang.lua"
	},
	{
		begin: "(^[ \\t]+)?(?=--)",
		beginCaptures: {
			"1": {
				name: "punctuation.whitespace.comment.leading.lua"
			}
		},
		end: "(?!\\G)((?!^)[ \\t]+\\n)?",
		endCaptures: {
			"1": {
				name: "punctuation.whitespace.comment.trailing.lua"
			}
		},
		patterns: [
			{
				begin: "--\\[(=*)\\[",
				beginCaptures: {
					"0": {
						name: "punctuation.definition.comment.begin.lua"
					}
				},
				end: "\\]\\1\\]",
				endCaptures: {
					"0": {
						name: "punctuation.definition.comment.end.lua"
					}
				},
				name: "comment.block.lua"
			},
			{
				begin: "--",
				beginCaptures: {
					"0": {
						name: "punctuation.definition.comment.lua"
					}
				},
				end: "\\n",
				name: "comment.line.double-dash.lua"
			}
		]
	},
	{
		captures: {
			"1": {
				name: "keyword.control.goto.lua"
			},
			"2": {
				name: "constant.other.placeholder.lua"
			}
		},
		match: "\\b(goto)\\s+([a-zA-Z_][a-zA-Z0-9_]*)"
	},
	{
		captures: {
			"1": {
				name: "punctuation.definition.label.begin.lua"
			},
			"2": {
				name: "punctuation.definition.label.end.lua"
			}
		},
		match: "(::)[a-zA-Z_][a-zA-Z0-9_]*(::)",
		name: "constant.other.placeholder.lua"
	},
	{
		match: "\\b(break|do|else|for|if|elseif|goto|return|then|repeat|while|until|end|function|local|in)\\b",
		name: "keyword.control.lua"
	},
	{
		match: "(?<![^.]\\.|:)\\b(false|nil|true|_G|_VERSION|math\\.(pi|huge))\\b|(?<![.])\\.{3}(?!\\.)",
		name: "constant.language.lua"
	},
	{
		match: "(?<![^.]\\.|:)\\b(self)\\b",
		name: "variable.language.self.lua"
	},
	{
		match: "(?<![^.]\\.|:)\\b(assert|collectgarbage|dofile|error|getfenv|getmetatable|ipairs|loadfile|loadstring|module|next|pairs|pcall|print|rawequal|rawget|rawset|require|select|setfenv|setmetatable|tonumber|tostring|type|unpack|xpcall)\\b(?=\\s*(?:[({\"']|\\[\\[))",
		name: "support.function.lua"
	},
	{
		match: "(?<![^.]\\.|:)\\b(coroutine\\.(create|resume|running|status|wrap|yield)|string\\.(byte|char|dump|find|format|gmatch|gsub|len|lower|match|rep|reverse|sub|upper)|table\\.(concat|insert|maxn|remove|sort)|math\\.(abs|acos|asin|atan2?|ceil|cosh?|deg|exp|floor|fmod|frexp|ldexp|log|log10|max|min|modf|pow|rad|random|randomseed|sinh?|sqrt|tanh?)|io\\.(close|flush|input|lines|open|output|popen|read|tmpfile|type|write)|os\\.(clock|date|difftime|execute|exit|getenv|remove|rename|setlocale|time|tmpname)|package\\.(cpath|loaded|loadlib|path|preload|seeall)|debug\\.(debug|[gs]etfenv|[gs]ethook|getinfo|[gs]etlocal|[gs]etmetatable|getregistry|[gs]etupvalue|traceback))\\b(?=\\s*(?:[({\"']|\\[\\[))",
		name: "support.function.library.lua"
	},
	{
		match: "\\b(and|or|not)\\b",
		name: "keyword.operator.lua"
	},
	{
		match: "\\b([a-zA-Z_][a-zA-Z0-9_]*)\\b(?=\\s*(?:[({\"']|\\[\\[))",
		name: "support.function.any-method.lua"
	},
	{
		match: "(?<=[^.]\\.|:)\\b([a-zA-Z_][a-zA-Z0-9_]*)",
		name: "variable.other.lua"
	},
	{
		match: "\\+|-|%|#|\\*|\\/|\\^|==?|~=|<=?|>=?|(?<!\\.)\\.{2}(?!\\.)",
		name: "keyword.operator.lua"
	}
];
const repository = {
	escaped_char: {
		patterns: [
			{
				match: "\\\\[abfnrtvz\\\\\"'\\n]",
				name: "constant.character.escape.lua"
			},
			{
				match: "\\\\\\d{1,3}",
				name: "constant.character.escape.byte.lua"
			},
			{
				match: "\\\\x[0-9A-Fa-f][0-9A-Fa-f]",
				name: "constant.character.escape.byte.lua"
			},
			{
				match: "\\\\u\\{[0-9A-Fa-f]+\\}",
				name: "constant.character.escape.unicode.lua"
			},
			{
				match: "\\\\.",
				name: "invalid.illegal.character.escape.lua"
			}
		]
	}
};
const lua_tmLanguage = {
	information_for_contributors: information_for_contributors,
	version: version,
	name: name,
	scopeName: scopeName,
	patterns: patterns,
	repository: repository
};

export { lua_tmLanguage as default, information_for_contributors, name, patterns, repository, scopeName, version };
