const name = "slack-ochin";
const type = "dark";
const colors = {
	foreground: "#616161",
	focusBorder: "#161F26",
	"widget.shadow": "#161F2694",
	"input.background": "#FFF",
	"input.border": "#161F26",
	"input.foreground": "#000",
	"input.placeholderForeground": "#a0a0a0",
	"inputOption.activeBorder": "#3E313C",
	"inputValidation.errorBackground": "#F44C5E",
	"inputValidation.errorForeground": "#FFF",
	"inputValidation.infoBackground": "#6182b8",
	"inputValidation.infoForeground": "#FFF",
	"inputValidation.warningBackground": "#F6B555",
	"inputValidation.warningForeground": "#000",
	"list.activeSelectionBackground": "#5899C5",
	"list.activeSelectionForeground": "#fff",
	"list.hoverBackground": "#d5e1ea",
	"list.hoverForeground": "#fff",
	"list.focusBackground": "#d5e1ea",
	"list.focusForeground": "#fff",
	"list.inactiveSelectionBackground": "#5899C5",
	"list.inactiveSelectionForeground": "#fff",
	"list.highlightForeground": "#2D3E4C",
	"list.inactiveFocusBackground": "#161F26",
	"list.invalidItemForeground": "#fff",
	"button.background": "#475663",
	"button.foreground": "#FFF",
	"button.hoverBackground": "#161F26",
	"scrollbar.shadow": "#ffffff00",
	"scrollbarSlider.activeBackground": "#161F267e",
	"scrollbarSlider.background": "#161F267e",
	"scrollbarSlider.hoverBackground": "#161F267e",
	"badge.background": "#8AE773",
	"progressBar.background": "#8AE773",
	"editor.background": "#FFF",
	"editor.foreground": "#000",
	"editor.lineHighlightBackground": "#EEEEEE",
	"editor.wordHighlightStrongBackground": "#EEEEEE",
	"editor.selectionBackground": "#AED4FB",
	"editorLineNumber.foreground": "#b9b9b9",
	"editorActiveLineNumber.foreground": "#475663",
	"editor.findMatchBackground": "#AED4FB",
	"editorHint.foreground": "#F9F9F9",
	"editorHint.border": "#F9F9F9",
	"editor.wordHighlightBackground": "#AED4FB",
	"terminal.border": "#2D3E4C",
	"terminal.foreground": "#161F26",
	"terminal.ansiBlack": "#000000",
	"terminal.ansiBlue": "#6182b8",
	"terminal.ansiBrightBlack": "#90a4ae",
	"terminal.ansiBrightBlue": "#6182b8",
	"terminal.ansiBrightCyan": "#39adb5",
	"terminal.ansiBrightGreen": "#91b859",
	"terminal.ansiBrightMagenta": "#7c4dff",
	"terminal.ansiBrightRed": "#e53935",
	"terminal.ansiBrightWhite": "#ffffff",
	"terminal.ansiBrightYellow": "#ffb62c",
	"terminal.ansiCyan": "#39adb5",
	"terminal.ansiGreen": "#91b859",
	"terminal.ansiMagenta": "#7c4dff",
	"terminal.ansiRed": "#e53935",
	"terminal.ansiWhite": "#ffffff",
	"terminal.ansiYellow": "#ffb62c",
	"terminal.selectionBackground": "#0006",
	"panelTitle.activeForeground": "#161F26",
	"activityBar.background": "#161F26",
	"activityBar.foreground": "#FFF",
	"activityBar.dropBackground": "#FFF",
	"activityBarBadge.background": "#8AE773",
	"activityBarBadge.foreground": "#FFF",
	"panel.border": "#2D3E4C",
	"dropdown.background": "#FFF",
	"dropdown.listBackground": "#FFF",
	"dropdown.border": "#DCDEDF",
	"dropdown.foreground": "#DCDEDF",
	"sideBar.background": "#2D3E4C",
	"sideBar.foreground": "#DCDEDF",
	"sideBarTitle.foreground": "#FFF",
	"sideBarSectionHeader.foreground": "#FFF",
	"sideBarSectionHeader.background": "#161F26",
	"debugToolBar.background": "#161F26",
	"tab.border": "#F3F3F3",
	"tab.activeBackground": "#FFF",
	"tab.inactiveForeground": "#686868",
	"tab.inactiveBackground": "#F3F3F3",
	"tab.activeForeground": "#000",
	"editorGroupHeader.tabsBackground": "#2D3E4C",
	"statusBar.foreground": "#FFF",
	"statusBar.background": "#5899C5",
	"statusBar.debuggingBackground": "#8AE773",
	"statusBar.noFolderBackground": "#161F26",
	"extensionButton.prominentBackground": "#475663",
	"extensionButton.prominentForeground": "#F6F6F6",
	"extensionButton.prominentHoverBackground": "#161F26",
	"gitDecoration.modifiedResourceForeground": "#ECB22E",
	"gitDecoration.deletedResourceForeground": "#FFF",
	"gitDecoration.untrackedResourceForeground": "#ECB22E",
	"gitDecoration.ignoredResourceForeground": "#877583",
	"gitDecoration.addedResourceForeground": "#ECB22E",
	"gitDecoration.conflictingResourceForeground": "#FFF",
	"notificationCenter.border": "#161F26",
	"notificationToast.border": "#161F26",
	"notifications.foreground": "#FFF",
	"notifications.background": "#161F26",
	"notifications.border": "#161F26",
	"notificationCenterHeader.foreground": "#FFF",
	"notificationLink.foreground": "#FFF",
	"titleBar.activeBackground": "#2D3E4C",
	"titleBar.activeForeground": "#FFF",
	"titleBar.inactiveBackground": "#161F26",
	"titleBar.inactiveForeground": "#685C66",
	"titleBar.border": "#2D3E4C",
	"welcomePage.buttonBackground": "#F3F3F3",
	"welcomePage.buttonHoverBackground": "#ECECEC",
	"editorWidget.background": "#F9F9F9",
	"editorWidget.border": "#dbdbdb",
	"editorSuggestWidget.foreground": "#2D3E4C",
	"editorSuggestWidget.highlightForeground": "#2D3E4C",
	"editorSuggestWidget.selectedBackground": "#b9b9b9",
	"editorGroup.emptyBackground": "#2D3E4C",
	"editorGroup.focusedEmptyBorder": "#2D3E4C",
	"editorPane.background": "#2D3E4C",
	"breadcrumb.foreground": "#161F26",
	"breadcrumb.focusForeground": "#475663",
	"settings.headerForeground": "#161F26",
	"settings.dropdownForeground": "#161F26",
	"settings.dropdownBorder": "#161F26",
	"menu.separatorBackground": "#F9FAFA",
	"menu.background": "#161F26",
	"menu.foreground": "#F9FAFA",
	"textPreformat.foreground": "#161F26",
	"editorIndentGuide.background": "#F3F3F3",
	"editorIndentGuide.activeBackground": "#dbdbdb",
	"debugExceptionWidget.background": "#AED4FB",
	"debugExceptionWidget.border": "#161F26",
	"editorMarkerNavigation.background": "#F9F9F9",
	"editorMarkerNavigationInfo.background": "#6182b8",
	"editorMarkerNavigationError.background": "#F44C5E",
	"editorMarkerNavigationWarning.background": "#F6B555"
};
const tokenColors = [
	{
		settings: {
			foreground: "#002339"
		}
	},
	{
		scope: [
			"meta.paragraph.markdown",
			"string.other.link.description.title.markdown"
		],
		settings: {
			foreground: "#110000"
		}
	},
	{
		scope: [
			"entity.name.section.markdown",
			"punctuation.definition.heading.markdown"
		],
		settings: {
			foreground: "#034c7c"
		}
	},
	{
		scope: [
			"punctuation.definition.string.begin.markdown",
			"punctuation.definition.string.end.markdown",
			"markup.quote.markdown"
		],
		settings: {
			foreground: "#00AC8F"
		}
	},
	{
		scope: [
			"markup.quote.markdown"
		],
		settings: {
			fontStyle: "italic",
			foreground: "#003494"
		}
	},
	{
		scope: [
			"markup.bold.markdown",
			"punctuation.definition.bold.markdown"
		],
		settings: {
			fontStyle: "bold",
			foreground: "#4e76b5"
		}
	},
	{
		scope: [
			"markup.italic.markdown",
			"punctuation.definition.italic.markdown"
		],
		settings: {
			fontStyle: "italic",
			foreground: "#C792EA"
		}
	},
	{
		scope: [
			"markup.inline.raw.string.markdown",
			"markup.fenced_code.block.markdown"
		],
		settings: {
			fontStyle: "italic",
			foreground: "#0460b1"
		}
	},
	{
		scope: [
			"punctuation.definition.metadata.markdown"
		],
		settings: {
			foreground: "#00AC8F"
		}
	},
	{
		scope: [
			"markup.underline.link.image.markdown",
			"markup.underline.link.markdown"
		],
		settings: {
			foreground: "#924205"
		}
	},
	{
		name: "Comment",
		scope: "comment",
		settings: {
			fontStyle: "italic",
			foreground: "#357b42"
		}
	},
	{
		name: "String",
		scope: "string",
		settings: {
			foreground: "#a44185"
		}
	},
	{
		name: "Number",
		scope: "constant.numeric",
		settings: {
			foreground: "#174781"
		}
	},
	{
		name: "Constant",
		scope: "constant",
		settings: {
			foreground: "#174781"
		}
	},
	{
		name: "Built-in constant",
		scope: "language.method",
		settings: {
			foreground: "#174781"
		}
	},
	{
		name: "User-defined constant",
		scope: [
			"constant.character",
			"constant.other"
		],
		settings: {
			foreground: "#174781"
		}
	},
	{
		name: "Variable",
		scope: "variable",
		settings: {
			fontStyle: "",
			foreground: "#2f86d2"
		}
	},
	{
		name: "Variable",
		scope: "variable.language.this",
		settings: {
			fontStyle: "",
			foreground: "#000000"
		}
	},
	{
		name: "Keyword",
		scope: "keyword",
		settings: {
			fontStyle: "",
			foreground: "#7b30d0"
		}
	},
	{
		name: "Storage",
		scope: "storage",
		settings: {
			fontStyle: "",
			foreground: "#da5221"
		}
	},
	{
		name: "Storage type",
		scope: "storage.type",
		settings: {
			foreground: "#0991b6",
			fontStyle: ""
		}
	},
	{
		name: "Class name",
		scope: "entity.name.class",
		settings: {
			foreground: "#1172c7"
		}
	},
	{
		name: "Inherited class",
		scope: "entity.other.inherited-class",
		settings: {
			fontStyle: "",
			foreground: "#b02767"
		}
	},
	{
		name: "Function name",
		scope: "entity.name.function",
		settings: {
			fontStyle: "",
			foreground: "#7eb233"
		}
	},
	{
		name: "Function argument",
		scope: "variable.parameter",
		settings: {
			foreground: "#b1108e",
			fontStyle: ""
		}
	},
	{
		name: "Tag name",
		scope: "entity.name.tag",
		settings: {
			fontStyle: "",
			foreground: "#0444ac"
		}
	},
	{
		name: "Html Other",
		scope: "text.html.basic",
		settings: {
			fontStyle: "",
			foreground: "#0071ce"
		}
	},
	{
		name: "Entity Name Type",
		scope: "entity.name.type",
		settings: {
			foreground: "#0444ac"
		}
	},
	{
		name: "Tag attribute",
		scope: "entity.other.attribute-name",
		settings: {
			fontStyle: "italic",
			foreground: "#df8618"
		}
	},
	{
		name: "Library function",
		scope: "support.function",
		settings: {
			fontStyle: "",
			foreground: "#1ab394"
		}
	},
	{
		name: "Library constant",
		scope: "support.constant",
		settings: {
			fontStyle: "",
			foreground: "#174781"
		}
	},
	{
		name: "Library class/type",
		scope: [
			"support.type",
			"support.class"
		],
		settings: {
			foreground: "#dc3eb7"
		}
	},
	{
		name: "Library variable",
		scope: "support.other.variable",
		settings: {
			foreground: "#224555"
		}
	},
	{
		name: "Invalid",
		scope: "invalid",
		settings: {
			fontStyle: " italic bold underline",
			foreground: "#207bb8"
		}
	},
	{
		name: "Invalid deprecated",
		scope: "invalid.deprecated",
		settings: {
			foreground: "#207bb8",
			fontStyle: " bold italic underline"
		}
	},
	{
		name: "[JSON] - Support",
		scope: "source.json support",
		settings: {
			foreground: "#6dbdfa"
		}
	},
	{
		name: "[JSON] - String",
		scope: [
			"source.json string",
			"source.json punctuation.definition.string"
		],
		settings: {
			foreground: "#00820f"
		}
	},
	{
		name: "Lists",
		scope: "markup.list",
		settings: {
			foreground: "#207bb8"
		}
	},
	{
		name: "Headings",
		scope: [
			"markup.heading punctuation.definition.heading",
			"entity.name.section"
		],
		settings: {
			fontStyle: "",
			foreground: "#4FB4D8"
		}
	},
	{
		name: "Support",
		scope: [
			"text.html.markdown meta.paragraph meta.link.inline",
			"text.html.markdown meta.paragraph meta.link.inline punctuation.definition.string.begin.markdown",
			"text.html.markdown meta.paragraph meta.link.inline punctuation.definition.string.end.markdown"
		],
		settings: {
			foreground: "#87429A"
		}
	},
	{
		name: "Quotes",
		scope: "markup.quote",
		settings: {
			foreground: "#87429A"
		}
	},
	{
		name: "Bold",
		scope: "markup.bold",
		settings: {
			fontStyle: "bold",
			foreground: "#08134A"
		}
	},
	{
		name: "Italic",
		scope: [
			"markup.italic",
			"punctuation.definition.italic"
		],
		settings: {
			fontStyle: "italic",
			foreground: "#174781"
		}
	},
	{
		name: "Link Url",
		scope: "meta.link",
		settings: {
			foreground: "#87429A"
		}
	}
];
const slackOchin = {
	name: name,
	type: type,
	colors: colors,
	tokenColors: tokenColors
};

export { colors, slackOchin as default, name, tokenColors, type };
