const name = "vitesse-light";
const base = "vs";
const colors = {
	focusBorder: "#00000000",
	foreground: "#393a34",
	descriptionForeground: "#393a3490",
	errorForeground: "#ab5959",
	"textLink.foreground": "#1c6b48",
	"textLink.activeForeground": "#1c6b48",
	"textBlockQuote.background": "#ffffff",
	"textBlockQuote.border": "#f0f0f0",
	"textCodeBlock.background": "#ffffff",
	"textPreformat.foreground": "#586069",
	"textSeparator.foreground": "#d1d5da",
	"button.background": "#1c6b48",
	"button.foreground": "#ffffff",
	"button.hoverBackground": "#1c6b48",
	"checkbox.background": "#f5f5f5",
	"checkbox.border": "#d1d5da",
	"dropdown.background": "#ffffff",
	"dropdown.border": "#f0f0f0",
	"dropdown.foreground": "#393a34",
	"dropdown.listBackground": "#f5f5f5",
	"input.background": "#f5f5f5",
	"input.border": "#f0f0f0",
	"input.foreground": "#393a34",
	"input.placeholderForeground": "#393a3490",
	"badge.foreground": "#ffffff",
	"badge.background": "#393a3490",
	"progressBar.background": "#1c6b48",
	"titleBar.activeForeground": "#4e4f47",
	"titleBar.activeBackground": "#ffffff",
	"titleBar.inactiveForeground": "#6a737d",
	"titleBar.inactiveBackground": "#ffffff",
	"titleBar.border": "#f5f5f5",
	"activityBar.foreground": "#393a34",
	"activityBar.inactiveForeground": "#393a3450",
	"activityBar.background": "#ffffff",
	"activityBarBadge.foreground": "#ffffff",
	"activityBarBadge.background": "#4e4f47",
	"activityBar.activeBorder": "#1c6b48",
	"activityBar.border": "#f0f0f0",
	"sideBar.foreground": "#4e4f47",
	"sideBar.background": "#ffffff",
	"sideBar.border": "#f0f0f0",
	"sideBarTitle.foreground": "#393a34",
	"sideBarSectionHeader.foreground": "#393a34",
	"sideBarSectionHeader.background": "#ffffff",
	"sideBarSectionHeader.border": "#f0f0f0",
	"list.hoverForeground": "#393a34",
	"list.inactiveSelectionForeground": "#393a34",
	"list.activeSelectionForeground": "#393a34",
	"list.hoverBackground": "#f5f5f5",
	"list.inactiveSelectionBackground": "#ffffff",
	"list.activeSelectionBackground": "#f5f5f5",
	"list.inactiveFocusBackground": "#ffffff",
	"list.focusBackground": "#f5f5f5",
	"tree.indentGuidesStroke": "#e1e4e8",
	"notificationCenterHeader.foreground": "#6a737d",
	"notificationCenterHeader.background": "#ffffff",
	"notifications.foreground": "#393a34",
	"notifications.background": "#ffffff",
	"notifications.border": "#f0f0f0",
	"notificationsErrorIcon.foreground": "#ab5959",
	"notificationsWarningIcon.foreground": "#a65e2b",
	"notificationsInfoIcon.foreground": "#296aa3",
	"pickerGroup.border": "#e1e4e8",
	"pickerGroup.foreground": "#393a34",
	"quickInput.background": "#ffffff",
	"quickInput.foreground": "#393a34",
	"statusBar.foreground": "#4e4f47",
	"statusBar.background": "#ffffff",
	"statusBar.border": "#f0f0f0",
	"statusBar.noFolderBackground": "#ffffff",
	"statusBar.debuggingBackground": "#f5f5f5",
	"statusBar.debuggingForeground": "#4e4f47",
	"statusBarItem.prominentBackground": "#f5f5f5",
	"editorGroupHeader.tabsBackground": "#ffffff",
	"editorGroupHeader.tabsBorder": "#f0f0f0",
	"editorGroup.border": "#f0f0f0",
	"tab.activeForeground": "#393a34",
	"tab.inactiveForeground": "#6a737d",
	"tab.inactiveBackground": "#ffffff",
	"tab.activeBackground": "#ffffff",
	"tab.hoverBackground": "#f5f5f5",
	"tab.unfocusedHoverBackground": "#ffffff",
	"tab.border": "#f0f0f0",
	"tab.unfocusedActiveBorderTop": "#f0f0f0",
	"tab.activeBorder": "#f0f0f0",
	"tab.unfocusedActiveBorder": "#f0f0f0",
	"tab.activeBorderTop": "#393a3490",
	"breadcrumb.foreground": "#6a737d",
	"breadcrumb.focusForeground": "#393a34",
	"breadcrumb.activeSelectionForeground": "#586069",
	"breadcrumbPicker.background": "#ffffff",
	"editor.foreground": "#393a34",
	"editor.background": "#ffffff",
	"editorWidget.background": "#ffffff",
	"editor.foldBackground": "#ffffff",
	"editor.lineHighlightBackground": "#f5f5f5",
	"editorLineNumber.foreground": "#393a3450",
	"editorLineNumber.activeForeground": "#4e4f47",
	"editorIndentGuide.background": "#00000015",
	"editorIndentGuide.activeBackground": "#00000030",
	"editorWhitespace.foreground": "#00000015",
	"editor.findMatchBackground": "#e6cc7744",
	"editor.findMatchHighlightBackground": "#e6cc7766",
	"editor.inactiveSelectionBackground": "#22222210",
	"editor.selectionBackground": "#22222210",
	"editor.selectionHighlightBackground": "#22222215",
	"editor.wordHighlightBackground": "#1c6b4805",
	"editor.wordHighlightStrongBackground": "#1c6b4810",
	"editorBracketMatch.background": "#1c6b4820",
	"diffEditor.insertedTextBackground": "#1c6b4815",
	"diffEditor.removedTextBackground": "#ab595910",
	"scrollbar.shadow": "#6a737d33",
	"scrollbarSlider.background": "#393a3410",
	"scrollbarSlider.hoverBackground": "#393a3450",
	"scrollbarSlider.activeBackground": "#393a3450",
	"editorOverviewRuler.border": "#fff",
	"panel.background": "#ffffff",
	"panel.border": "#f0f0f0",
	"panelTitle.activeBorder": "#1c6b48",
	"panelTitle.activeForeground": "#393a34",
	"panelTitle.inactiveForeground": "#6a737d",
	"panelInput.border": "#e1e4e8",
	"terminal.foreground": "#393a34",
	"terminal.ansiBrightBlack": "#aaaaaa",
	"terminal.ansiBrightBlue": "#296aa3",
	"terminal.ansiBrightCyan": "#2993a3",
	"terminal.ansiBrightGreen": "#1c6b48",
	"terminal.ansiBrightMagenta": "#b05a78",
	"terminal.ansiBrightRed": "#ab5959",
	"terminal.ansiBrightWhite": "#dbd7ca",
	"terminal.ansiBrightYellow": "#bda437",
	"terminal.ansiBlack": "#121212",
	"terminal.ansiBlue": "#296aa3",
	"terminal.ansiCyan": "#2993a3",
	"terminal.ansiGreen": "#1c6b48",
	"terminal.ansiMagenta": "#b05a78",
	"terminal.ansiRed": "#ab5959",
	"terminal.ansiWhite": "#dbd7ca",
	"terminal.ansiYellow": "#bda437",
	"gitDecoration.addedResourceForeground": "#1c6b48",
	"gitDecoration.modifiedResourceForeground": "#296aa3",
	"gitDecoration.deletedResourceForeground": "#ab5959",
	"gitDecoration.untrackedResourceForeground": "#2993a3",
	"gitDecoration.ignoredResourceForeground": "#393a3450",
	"gitDecoration.conflictingResourceForeground": "#a65e2b",
	"gitDecoration.submoduleResourceForeground": "#393a3490",
	"editorGutter.modifiedBackground": "#296aa3",
	"editorGutter.addedBackground": "#1c6b48",
	"editorGutter.deletedBackground": "#ab5959",
	"editorBracketHighlight.foreground1": "#2993a3",
	"editorBracketHighlight.foreground2": "#1c6b48",
	"editorBracketHighlight.foreground3": "#a65e2b",
	"editorBracketHighlight.foreground4": "#b05a78",
	"editorBracketHighlight.foreground5": "#bda437",
	"editorBracketHighlight.foreground6": "#2f8a89",
	"debugToolBar.background": "#ffffff",
	"editor.stackFrameHighlightBackground": "#fffbdd",
	"editor.focusedStackFrameHighlightBackground": "#fff5b1",
	"peekViewEditor.background": "#ffffff",
	"peekViewResult.background": "#ffffff",
	"settings.headerForeground": "#393a34",
	"settings.modifiedItemIndicator": "#1c6b48",
	"welcomePage.buttonBackground": "#f6f8fa",
	"welcomePage.buttonHoverBackground": "#e1e4e8",
	"problemsErrorIcon.foreground": "#ab5959",
	"problemsWarningIcon.foreground": "#a65e2b",
	"problemsInfoIcon.foreground": "#296aa3",
	"editorError.foreground": "#ab5959",
	"editorWarning.foreground": "#a65e2b",
	"editorInfo.foreground": "#296aa3",
	"editorHint.foreground": "#1c6b48",
	"editorGutter.commentRangeForeground": "#393a3450",
	"editorGutter.foldingControlForeground": "#393a3490"
};
const semanticHighlighting = true;
const semanticTokenColors = {
	namespace: "#b05a78",
	"interface": "#2e8f63",
	"class": "#2993a3"
};
const tokenColors = [
	{
		scope: [
			"comment",
			"punctuation.definition.comment",
			"string.comment"
		],
		settings: {
			foreground: "#a0ada0"
		}
	},
	{
		scope: [
			"punctuation",
			"delimiter",
			"delimiter.bracket",
			"meta.tag.inline.any.html",
			"meta.tag.block.any.html",
			"meta.brace"
		],
		settings: {
			foreground: "#8e8f8b"
		}
	},
	{
		scope: [
			"constant",
			"entity.name.constant",
			"variable.other.constant",
			"variable.language",
			"meta.definition.variable"
		],
		settings: {
			foreground: "#a65e2b"
		}
	},
	{
		scope: [
			"entity",
			"entity.name"
		],
		settings: {
			foreground: "#6c7834"
		}
	},
	{
		scope: "variable.parameter.function",
		settings: {
			foreground: "#393a34"
		}
	},
	{
		scope: [
			"entity.name.tag",
			"tag.html"
		],
		settings: {
			foreground: "#2f8a89"
		}
	},
	{
		scope: "entity.name.function",
		settings: {
			foreground: "#6c7834"
		}
	},
	{
		scope: "keyword",
		settings: {
			foreground: "#1c6b48"
		}
	},
	{
		scope: [
			"storage",
			"storage.type"
		],
		settings: {
			foreground: "#ab5959"
		}
	},
	{
		scope: [
			"storage.modifier.package",
			"storage.modifier.import",
			"storage.type.java"
		],
		settings: {
			foreground: "#393a34"
		}
	},
	{
		scope: [
			"string",
			"punctuation.definition.string",
			"string punctuation.section.embedded source",
			"attribute.value"
		],
		settings: {
			foreground: "#b56959"
		}
	},
	{
		scope: "support",
		settings: {
			foreground: "#b58451"
		}
	},
	{
		scope: [
			"meta.property-name",
			"entity.other.attribute-name",
			"meta.object-literal.key",
			"attribute.name"
		],
		settings: {
			foreground: "#b58451"
		}
	},
	{
		scope: [
			"variable",
			"identifier"
		],
		settings: {
			foreground: "#8c862b"
		}
	},
	{
		scope: "namespace",
		settings: {
			foreground: "#b05a78"
		}
	},
	{
		scope: "keyword.operator",
		settings: {
			foreground: "#ab5959"
		}
	},
	{
		scope: "invalid.broken",
		settings: {
			fontStyle: "italic",
			foreground: "#b31d28"
		}
	},
	{
		scope: "invalid.deprecated",
		settings: {
			fontStyle: "italic",
			foreground: "#b31d28"
		}
	},
	{
		scope: "invalid.illegal",
		settings: {
			fontStyle: "italic",
			foreground: "#b31d28"
		}
	},
	{
		scope: "invalid.unimplemented",
		settings: {
			fontStyle: "italic",
			foreground: "#b31d28"
		}
	},
	{
		scope: "carriage-return",
		settings: {
			fontStyle: "italic underline",
			background: "#d73a49",
			foreground: "#fafbfc",
			content: "^M"
		}
	},
	{
		scope: "message.error",
		settings: {
			foreground: "#b31d28"
		}
	},
	{
		scope: "string source",
		settings: {
			foreground: "#393a34"
		}
	},
	{
		scope: "string variable",
		settings: {
			foreground: "#b56959"
		}
	},
	{
		scope: [
			"source.regexp",
			"string.regexp"
		],
		settings: {
			foreground: "#ab5e3f"
		}
	},
	{
		scope: [
			"string.regexp.character-class",
			"string.regexp constant.character.escape",
			"string.regexp source.ruby.embedded",
			"string.regexp string.regexp.arbitrary-repitition"
		],
		settings: {
			foreground: "#b56959"
		}
	},
	{
		scope: "string.regexp constant.character.escape",
		settings: {
			foreground: "#bda437"
		}
	},
	{
		scope: "support.constant",
		settings: {
			foreground: "#a65e2b"
		}
	},
	{
		scope: "support.variable",
		settings: {
			foreground: "#2f8a89"
		}
	},
	{
		scope: [
			"constant.numeric",
			"number"
		],
		settings: {
			foreground: "#296aa3"
		}
	},
	{
		scope: [
			"keyword.other.unit"
		],
		settings: {
			foreground: "#ab5959"
		}
	},
	{
		scope: "constant.language.boolean",
		settings: {
			foreground: "#1c6b48"
		}
	},
	{
		scope: "meta.module-reference",
		settings: {
			foreground: "#1c6b48"
		}
	},
	{
		scope: "punctuation.definition.list.begin.markdown",
		settings: {
			foreground: "#a65e2b"
		}
	},
	{
		scope: [
			"markup.heading",
			"markup.heading entity.name"
		],
		settings: {
			fontStyle: "bold",
			foreground: "#1c6b48"
		}
	},
	{
		scope: "markup.quote",
		settings: {
			foreground: "#1c6b48"
		}
	},
	{
		scope: "markup.italic",
		settings: {
			fontStyle: "italic",
			foreground: "#393a34"
		}
	},
	{
		scope: "markup.bold",
		settings: {
			fontStyle: "bold",
			foreground: "#393a34"
		}
	},
	{
		scope: "markup.raw",
		settings: {
			foreground: "#1c6b48"
		}
	},
	{
		scope: [
			"markup.deleted",
			"meta.diff.header.from-file",
			"punctuation.definition.deleted"
		],
		settings: {
			background: "#ffeef0",
			foreground: "#b31d28"
		}
	},
	{
		scope: [
			"markup.inserted",
			"meta.diff.header.to-file",
			"punctuation.definition.inserted"
		],
		settings: {
			background: "#f0fff4",
			foreground: "#22863a"
		}
	},
	{
		scope: [
			"markup.changed",
			"punctuation.definition.changed"
		],
		settings: {
			background: "#ffebda",
			foreground: "#e36209"
		}
	},
	{
		scope: [
			"markup.ignored",
			"markup.untracked"
		],
		settings: {
			foreground: "#f6f8fa",
			background: "#005cc5"
		}
	},
	{
		scope: "meta.diff.range",
		settings: {
			foreground: "#6f42c1",
			fontStyle: "bold"
		}
	},
	{
		scope: "meta.diff.header",
		settings: {
			foreground: "#005cc5"
		}
	},
	{
		scope: "meta.separator",
		settings: {
			fontStyle: "bold",
			foreground: "#005cc5"
		}
	},
	{
		scope: "meta.output",
		settings: {
			foreground: "#005cc5"
		}
	},
	{
		scope: [
			"brackethighlighter.tag",
			"brackethighlighter.curly",
			"brackethighlighter.round",
			"brackethighlighter.square",
			"brackethighlighter.angle",
			"brackethighlighter.quote"
		],
		settings: {
			foreground: "#586069"
		}
	},
	{
		scope: "brackethighlighter.unmatched",
		settings: {
			foreground: "#b31d28"
		}
	},
	{
		scope: [
			"constant.other.reference.link",
			"string.other.link",
			"punctuation.definition.string.begin.markdown",
			"punctuation.definition.string.end.markdown"
		],
		settings: {
			foreground: "#b56959"
		}
	},
	{
		scope: [
			"markup.underline.link.markdown"
		],
		settings: {
			foreground: "#393a3490",
			fontStyle: "underline"
		}
	},
	{
		scope: [
			"type.identifier"
		],
		settings: {
			foreground: "#2993a3"
		}
	}
];
const rules = [
	{
		token: "comment",
		foreground: "a0ada0"
	},
	{
		token: "punctuation.definition.comment",
		foreground: "a0ada0"
	},
	{
		token: "string.comment",
		foreground: "a0ada0"
	},
	{
		token: "punctuation",
		foreground: "8e8f8b"
	},
	{
		token: "delimiter",
		foreground: "8e8f8b"
	},
	{
		token: "delimiter.bracket",
		foreground: "8e8f8b"
	},
	{
		token: "meta.tag.inline.any.html",
		foreground: "8e8f8b"
	},
	{
		token: "meta.tag.block.any.html",
		foreground: "8e8f8b"
	},
	{
		token: "meta.brace",
		foreground: "8e8f8b"
	},
	{
		token: "constant",
		foreground: "a65e2b"
	},
	{
		token: "entity.name.constant",
		foreground: "a65e2b"
	},
	{
		token: "variable.other.constant",
		foreground: "a65e2b"
	},
	{
		token: "variable.language",
		foreground: "a65e2b"
	},
	{
		token: "meta.definition.variable",
		foreground: "a65e2b"
	},
	{
		token: "entity",
		foreground: "6c7834"
	},
	{
		token: "entity.name",
		foreground: "6c7834"
	},
	{
		token: "variable.parameter.function",
		foreground: "393a34"
	},
	{
		token: "entity.name.tag",
		foreground: "2f8a89"
	},
	{
		token: "tag.html",
		foreground: "2f8a89"
	},
	{
		token: "entity.name.function",
		foreground: "6c7834"
	},
	{
		token: "keyword",
		foreground: "1c6b48"
	},
	{
		token: "storage",
		foreground: "ab5959"
	},
	{
		token: "storage.type",
		foreground: "ab5959"
	},
	{
		token: "storage.modifier.package",
		foreground: "393a34"
	},
	{
		token: "storage.modifier.import",
		foreground: "393a34"
	},
	{
		token: "storage.type.java",
		foreground: "393a34"
	},
	{
		token: "string",
		foreground: "b56959"
	},
	{
		token: "punctuation.definition.string",
		foreground: "b56959"
	},
	{
		token: "string punctuation.section.embedded source",
		foreground: "b56959"
	},
	{
		token: "attribute.value",
		foreground: "b56959"
	},
	{
		token: "support",
		foreground: "b58451"
	},
	{
		token: "meta.property-name",
		foreground: "b58451"
	},
	{
		token: "entity.other.attribute-name",
		foreground: "b58451"
	},
	{
		token: "meta.object-literal.key",
		foreground: "b58451"
	},
	{
		token: "attribute.name",
		foreground: "b58451"
	},
	{
		token: "variable",
		foreground: "8c862b"
	},
	{
		token: "identifier",
		foreground: "8c862b"
	},
	{
		token: "namespace",
		foreground: "b05a78"
	},
	{
		token: "keyword.operator",
		foreground: "ab5959"
	},
	{
		token: "invalid.broken",
		foreground: "b31d28"
	},
	{
		token: "invalid.deprecated",
		foreground: "b31d28"
	},
	{
		token: "invalid.illegal",
		foreground: "b31d28"
	},
	{
		token: "invalid.unimplemented",
		foreground: "b31d28"
	},
	{
		token: "carriage-return",
		foreground: "fafbfc"
	},
	{
		token: "message.error",
		foreground: "b31d28"
	},
	{
		token: "string source",
		foreground: "393a34"
	},
	{
		token: "string variable",
		foreground: "b56959"
	},
	{
		token: "source.regexp",
		foreground: "ab5e3f"
	},
	{
		token: "string.regexp",
		foreground: "ab5e3f"
	},
	{
		token: "string.regexp.character-class",
		foreground: "b56959"
	},
	{
		token: "string.regexp constant.character.escape",
		foreground: "b56959"
	},
	{
		token: "string.regexp source.ruby.embedded",
		foreground: "b56959"
	},
	{
		token: "string.regexp string.regexp.arbitrary-repitition",
		foreground: "b56959"
	},
	{
		token: "string.regexp constant.character.escape",
		foreground: "bda437"
	},
	{
		token: "support.constant",
		foreground: "a65e2b"
	},
	{
		token: "support.variable",
		foreground: "2f8a89"
	},
	{
		token: "constant.numeric",
		foreground: "296aa3"
	},
	{
		token: "number",
		foreground: "296aa3"
	},
	{
		token: "keyword.other.unit",
		foreground: "ab5959"
	},
	{
		token: "constant.language.boolean",
		foreground: "1c6b48"
	},
	{
		token: "meta.module-reference",
		foreground: "1c6b48"
	},
	{
		token: "punctuation.definition.list.begin.markdown",
		foreground: "a65e2b"
	},
	{
		token: "markup.heading",
		foreground: "1c6b48"
	},
	{
		token: "markup.heading entity.name",
		foreground: "1c6b48"
	},
	{
		token: "markup.quote",
		foreground: "1c6b48"
	},
	{
		token: "markup.italic",
		foreground: "393a34"
	},
	{
		token: "markup.bold",
		foreground: "393a34"
	},
	{
		token: "markup.raw",
		foreground: "1c6b48"
	},
	{
		token: "markup.deleted",
		foreground: "b31d28"
	},
	{
		token: "meta.diff.header.from-file",
		foreground: "b31d28"
	},
	{
		token: "punctuation.definition.deleted",
		foreground: "b31d28"
	},
	{
		token: "markup.inserted",
		foreground: "22863a"
	},
	{
		token: "meta.diff.header.to-file",
		foreground: "22863a"
	},
	{
		token: "punctuation.definition.inserted",
		foreground: "22863a"
	},
	{
		token: "markup.changed",
		foreground: "e36209"
	},
	{
		token: "punctuation.definition.changed",
		foreground: "e36209"
	},
	{
		token: "markup.ignored",
		foreground: "f6f8fa"
	},
	{
		token: "markup.untracked",
		foreground: "f6f8fa"
	},
	{
		token: "meta.diff.range",
		foreground: "6f42c1"
	},
	{
		token: "meta.diff.header",
		foreground: "005cc5"
	},
	{
		token: "meta.separator",
		foreground: "005cc5"
	},
	{
		token: "meta.output",
		foreground: "005cc5"
	},
	{
		token: "brackethighlighter.tag",
		foreground: "586069"
	},
	{
		token: "brackethighlighter.curly",
		foreground: "586069"
	},
	{
		token: "brackethighlighter.round",
		foreground: "586069"
	},
	{
		token: "brackethighlighter.square",
		foreground: "586069"
	},
	{
		token: "brackethighlighter.angle",
		foreground: "586069"
	},
	{
		token: "brackethighlighter.quote",
		foreground: "586069"
	},
	{
		token: "brackethighlighter.unmatched",
		foreground: "b31d28"
	},
	{
		token: "constant.other.reference.link",
		foreground: "b56959"
	},
	{
		token: "string.other.link",
		foreground: "b56959"
	},
	{
		token: "punctuation.definition.string.begin.markdown",
		foreground: "b56959"
	},
	{
		token: "punctuation.definition.string.end.markdown",
		foreground: "b56959"
	},
	{
		token: "markup.underline.link.markdown",
		foreground: "393a3490"
	},
	{
		token: "type.identifier",
		foreground: "2993a3"
	}
];
const vitesseLight = {
	name: name,
	base: base,
	colors: colors,
	semanticHighlighting: semanticHighlighting,
	semanticTokenColors: semanticTokenColors,
	tokenColors: tokenColors,
	rules: rules
};

export { base, colors, vitesseLight as default, name, rules, semanticHighlighting, semanticTokenColors, tokenColors };
